/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.boss;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierBehaviour;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.boss.RandomSoldierPropertyGenerator;
import net.bumblebee.claysoldiers.init.ModBossBehaviours;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.soldierproperties.SoldierProperty;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMapReader;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum ClaySoldierBossEquipment {
    NORMAL(ModBossBehaviours.DEFAULT, Map.of(), () -> SoldierPropertyMap.of(new SoldierProperty<Float>(SoldierPropertyTypes.SIZE.get(), Float.valueOf(5.0f)), SoldierPropertyTypes.ATTACK_RANGE.get().createProperty(Float.valueOf(1.0f)))),
    VAMPIRE(ModBossBehaviours.VAMPIRE, Map.of(), () -> SoldierPropertyMap.of(new SoldierProperty<Float>(SoldierPropertyTypes.SIZE.get(), Float.valueOf(4.0f)), new SoldierProperty<Float>(SoldierPropertyTypes.ATTACK_RANGE.get(), Float.valueOf(1.0f)))),
    ZOMBIE(ModBossBehaviours.ZOMBIE, Map.of(), () -> SoldierPropertyMap.of(new SoldierProperty<Float>(SoldierPropertyTypes.SIZE.get(), Float.valueOf(4.0f)), new SoldierProperty<Float>(SoldierPropertyTypes.ATTACK_RANGE.get(), Float.valueOf(1.0f)))),
    RANDOM((boss, weight, team, waxed) -> ClaySoldierBossEquipment.setUpRandom(boss, weight));

    private final SetupFunction generator;

    private ClaySoldierBossEquipment(Supplier<BossClaySoldierBehaviour> bossAI, Map<SoldierEquipmentSlot, Supplier<ItemStack>> equipment, Supplier<SoldierPropertyMap> baseProperties) {
        this((boss, weight, team, waxed) -> {
            boss.setBaseProperties((SoldierPropertyMapReader)baseProperties.get());
            if (team == null) {
                team = Util.getRandomSafe(boss.registryAccess().lookupOrThrow(ModRegistries.CLAY_MOB_TEAMS).keySet().stream().filter(t -> !t.equals((Object)ClayMobTeamManger.NO_TEAM_TYPE)).toList(), (RandomSource)boss.getRandom()).orElse(ClayMobTeamManger.DEFAULT_TYPE);
            }
            boss.setClayTeamType(team);
            equipment.forEach((slot, item) -> boss.setItemSlot((SoldierEquipmentSlot)slot, (ItemStack)item.get()));
            boss.setWaxed(waxed);
            boss.setBossAI((BossClaySoldierBehaviour)bossAI.get());
        });
    }

    private ClaySoldierBossEquipment(SetupFunction generator) {
        this.generator = generator;
    }

    public void setUp(BossClaySoldierEntity boss, int weight, @Nullable ResourceLocation team, boolean waxed) {
        this.generator.setUp(boss, weight, team, waxed);
    }

    public static void setUpRandom(BossClaySoldierEntity boss, int weight) {
        RandomSource random = boss.getRandom();
        ResourceLocation team = Util.getRandomSafe(boss.registryAccess().lookupOrThrow(ModRegistries.CLAY_MOB_TEAMS).keySet().stream().filter(t -> !t.equals((Object)ClayMobTeamManger.NO_TEAM_TYPE)).toList(), (RandomSource)random).orElse(ClayMobTeamManger.DEFAULT_TYPE);
        boss.setBossAI((BossClaySoldierBehaviour)((Supplier)Util.getRandom(List.of(ModBossBehaviours.VAMPIRE, ModBossBehaviours.DEFAULT), (RandomSource)random)).get());
        boss.setClayTeamType(team);
        if (weight <= 0) {
            return;
        }
        if (random.nextBoolean()) {
            --weight;
            boss.setWaxed(true);
        }
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            if (weight <= 0) break;
            if (!random.nextBoolean()) continue;
            Optional opt = Util.getRandomSafe(ClaySoldiersCommon.DATA_MAP.getHoldableEffectForSlot(slot), (RandomSource)random);
            if (opt.isPresent() && ((Item)opt.get()).getDefaultInstance().is(ModTags.Items.SOLDIER_BOSS_EQUIPABLE)) {
                boss.setItemSlot(slot, ((Item)opt.orElseThrow()).getDefaultInstance());
                --weight;
                continue;
            }
            Optional opt2 = Util.getRandomSafe(ClaySoldiersCommon.DATA_MAP.getHoldableEffectForSlot(slot), (RandomSource)random);
            if (!opt2.isPresent() || !((Item)opt2.get()).getDefaultInstance().is(ModTags.Items.SOLDIER_BOSS_EQUIPABLE)) continue;
            boss.setItemSlot(slot, ((Item)opt2.orElseThrow()).getDefaultInstance());
            --weight;
        }
        SoldierPropertyMap map = RandomSoldierPropertyGenerator.generateRandom(random, weight + 3, RandomSoldierPropertyGenerator.BOSS);
        RandomSoldierPropertyGenerator.generateRandom(random, RandomSoldierPropertyGenerator.BOSS_WEIGHTLESS.size(), RandomSoldierPropertyGenerator.BOSS_WEIGHTLESS).forEach(map::addPropertyForce);
        boss.setBaseProperties(map);
    }

    private static interface SetupFunction {
        public void setUp(BossClaySoldierEntity var1, int var2, @Nullable ResourceLocation var3, boolean var4);
    }
}

