/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.entity.client.ClayMobStatusRenderlayer;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierArmorLayer;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierModel;
import net.bumblebee.claysoldiers.entity.client.WaxedRenderLayer;
import net.bumblebee.claysoldiers.entity.client.accesories.AccessoryRenderLayer;
import net.bumblebee.claysoldiers.entity.client.renderstates.AbstractClaySoldierRenderState;
import net.bumblebee.claysoldiers.entity.client.renderstates.ClayMobRenderState;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemDisplayContext;

public abstract class AbstractClaySoldierRenderer
extends HumanoidMobRenderer<AbstractClaySoldierEntity, AbstractClaySoldierRenderState, ClaySoldierModel> {
    public static final float SCALE = 0.25f;

    protected AbstractClaySoldierRenderer(EntityRendererProvider.Context pContext, ClaySoldierModel model) {
        super(pContext, (HumanoidModel)model, (HumanoidModel)model, 0.125f, new CustomHeadLayer.Transforms(0.25f, 0.25f, 0.25f));
        this.layers.removeIf(layer -> layer.getClass() == CustomHeadLayer.class || layer.getClass() == ItemInHandLayer.class);
        this.addLayer(new ClaySoldierArmorLayer((RenderLayerParent<AbstractClaySoldierRenderState, ClaySoldierModel>)this, new ClaySoldierModel(pContext.bakeLayer(ModelLayers.ZOMBIE_INNER_ARMOR)), new ClaySoldierModel(pContext.bakeLayer(ModelLayers.ZOMBIE_OUTER_ARMOR)), pContext.getModelManager(), pContext.getEquipmentAssets()));
        this.addLayer(new AccessoryRenderLayer((RenderLayerParent<AbstractClaySoldierRenderState, ClaySoldierModel>)this, pContext.getModelSet(), pContext.getEquipmentAssets()));
        this.addLayer(new ClayMobStatusRenderlayer(this, pContext.getEntityRenderDispatcher(), e -> e.isInSittingPose, s -> s.shouldShowStatus, s -> s.workStatus, s -> s.statusAttachmentPoint));
        this.addLayer(new WaxedRenderLayer(this));
        this.addLayer((RenderLayer)new ClaySoldierItemInHandLayer((RenderLayerParent<AbstractClaySoldierRenderState, ClaySoldierModel>)this));
    }

    protected void scale(AbstractClaySoldierRenderState renderState, PoseStack poseStack) {
        poseStack.scale(0.25f, 0.25f, 0.25f);
        this.scaleExplode(renderState, poseStack);
    }

    public void render(AbstractClaySoldierRenderState claySoldier, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        boolean isInvisible;
        boolean bodyVisible;
        RenderType rendertype;
        Direction direction;
        pPoseStack.pushPose();
        if (claySoldier.hasPose(Pose.SLEEPING) && (direction = claySoldier.bedOrientation) != null) {
            float f3 = claySoldier.eyeHeight - 0.1f;
            pPoseStack.translate((float)(-direction.getStepX()) * f3, 0.0f, (float)(-direction.getStepZ()) * f3);
        }
        float scale = claySoldier.scale;
        pPoseStack.scale(scale, scale, scale);
        this.setupRotations((LivingEntityRenderState)claySoldier, pPoseStack, claySoldier.bodyRot, 1.0f);
        pPoseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale(claySoldier, pPoseStack);
        pPoseStack.translate(0.0f, -1.501f, 0.0f);
        ((ClaySoldierModel)this.model).setupAnim(claySoldier);
        if (claySoldier.ridingPose == AbstractClaySoldierEntity.RidingPose.FIREWORK) {
            pPoseStack.translate(0.0, 0.5, 0.0);
        }
        if ((rendertype = this.getRenderType((LivingEntityRenderState)claySoldier, bodyVisible, isInvisible = !(bodyVisible = this.isBodyVisible(claySoldier)), claySoldier.appearsGlowing)) != null) {
            VertexConsumer vertexconsumer = pBuffer.getBuffer(rendertype);
            int overlay = AbstractClaySoldierRenderer.getOverlayCoords((LivingEntityRenderState)claySoldier, (float)this.getWhiteOverlayProgress(claySoldier));
            int color = this.getVariantForColor(claySoldier);
            if (claySoldier.veryAngry) {
                color = AbstractClaySoldierRenderer.shiftColorAngry(color);
            }
            this.renderModel(claySoldier, pPoseStack, vertexconsumer, pPackedLight, overlay, color, isInvisible ? 38 : 255);
        }
        if (this.shouldRenderLayers((LivingEntityRenderState)claySoldier)) {
            for (RenderLayer renderlayer : this.layers) {
                renderlayer.render(pPoseStack, pBuffer, pPackedLight, (EntityRenderState)claySoldier, claySoldier.yRot, claySoldier.xRot);
            }
        }
        this.renderCarried(claySoldier, pPoseStack, pBuffer, pPackedLight, OverlayTexture.NO_OVERLAY);
        pPoseStack.popPose();
        if (claySoldier.nameTag != null) {
            this.renderNameTag((EntityRenderState)claySoldier, claySoldier.nameTag, pPoseStack, pBuffer, pPackedLight);
        }
    }

    public AbstractClaySoldierRenderState createRenderState() {
        return new AbstractClaySoldierRenderState();
    }

    public void extractRenderState(AbstractClaySoldierEntity claySoldierEntity, AbstractClaySoldierRenderState claySoldierRenderState, float partialTick) {
        super.extractRenderState((Mob)claySoldierEntity, (HumanoidRenderState)claySoldierRenderState, partialTick);
        ClayMobRenderState.extractClayMobRenderState(claySoldierEntity, claySoldierRenderState, partialTick);
        claySoldierRenderState.isZombie = claySoldierEntity.isZombie();
        claySoldierRenderState.isAggressive = claySoldierEntity.isAggressive();
        claySoldierRenderState.hasShieldInOffhand = claySoldierEntity.hasShieldInHand(InteractionHand.OFF_HAND);
        claySoldierRenderState.hasShieldInMainHand = claySoldierEntity.hasShieldInHand(InteractionHand.MAIN_HAND);
        claySoldierRenderState.carriedItemStack = claySoldierEntity.getCarriedStack();
        this.itemModelResolver.updateForLiving(claySoldierRenderState.carriedItemRenderState, claySoldierRenderState.carriedItemStack, ItemDisplayContext.FIXED, false, (LivingEntity)claySoldierEntity);
        claySoldierRenderState.ridingPose = claySoldierEntity.getRidingPose();
        claySoldierRenderState.id = claySoldierEntity.getId();
        claySoldierRenderState.skinVariantId = claySoldierEntity.getSkinVariant();
        claySoldierRenderState.offhandOccupied = claySoldierEntity.handsOccupied(SoldierEquipmentSlot.OFFHAND);
        claySoldierRenderState.mainhandOccupied = claySoldierEntity.handsOccupied(SoldierEquipmentSlot.MAINHAND);
        claySoldierRenderState.isAlive = claySoldierEntity.isAlive();
        claySoldierRenderState.isFalling = claySoldierEntity.isFalling();
        claySoldierRenderState.swelling = claySoldierEntity.getSwelling(partialTick);
        claySoldierRenderState.offsetColor = claySoldierEntity.getOffsetColor().getColor((LivingEntity)claySoldierEntity, partialTick);
        claySoldierRenderState.allProperties = claySoldierEntity.allProperties();
        claySoldierRenderState.gliderSlot = claySoldierEntity.gliderSlot();
        claySoldierRenderState.isFallingWithGlider = claySoldierEntity.isFallingWithGlider();
        claySoldierRenderState.veryAngry = claySoldierEntity.isVeryAngry();
        claySoldierRenderState.setUpInventory(claySoldierEntity);
        claySoldierRenderState.fallFlyingTimeInTicks = (float)claySoldierEntity.getFallFlyingTicks() + partialTick;
        AbstractClaySoldierRenderState.extractCloakState(claySoldierEntity, claySoldierRenderState, partialTick);
        AbstractClaySoldierRenderState.extractAccessoryRenderState(claySoldierEntity, claySoldierRenderState, this.itemModelResolver);
    }

    protected void renderModel(AbstractClaySoldierRenderState soldier, PoseStack pPoseStack, VertexConsumer vertexConsumer, int pPackedLight, int overlayCords, int color, int alpha) {
        ((ClaySoldierModel)this.model).renderToBuffer(pPoseStack, vertexConsumer, pPackedLight, overlayCords, ARGB.color((int)alpha, (int)color));
    }

    protected int getVariantForColor(AbstractClaySoldierRenderState claySoldier) {
        return claySoldier.clayTeamColor;
    }

    private void renderCarried(AbstractClaySoldierRenderState soldier, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverleay) {
        if (!soldier.carriedItemRenderState.isEmpty()) {
            pPoseStack.pushPose();
            pPoseStack.translate(0.0, -0.55, 0.0);
            pPoseStack.mulPose(Axis.YP.rotationDegrees(135.0f));
            pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            pPoseStack.scale(1.5f, 1.5f, 1.5f);
            soldier.carriedItemRenderState.render(pPoseStack, pBuffer, pPackedLight, pPackedOverleay);
            pPoseStack.popPose();
        }
    }

    private void scaleExplode(AbstractClaySoldierRenderState claySoldier, PoseStack pPoseStack) {
        float swelling = claySoldier.swelling;
        float f1 = 1.0f + Mth.sin((float)(swelling * 100.0f)) * swelling * 0.01f;
        swelling = Mth.clamp((float)swelling, (float)0.0f, (float)1.0f);
        swelling *= swelling;
        swelling *= swelling;
        float f2 = (1.0f + swelling * 0.4f) * f1;
        float f3 = (1.0f + swelling * 0.1f) / f1;
        pPoseStack.scale(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(AbstractClaySoldierRenderState claySoldier) {
        float swelling = claySoldier.swelling;
        return (int)(swelling * 10.0f) % 2 == 0 ? 0.0f : Mth.clamp((float)swelling, (float)0.5f, (float)1.0f);
    }

    protected int getBlockLightLevel(AbstractClaySoldierEntity pEntity, BlockPos pPos) {
        return pEntity.allProperties().isGlowing() ? 15 : super.getBlockLightLevel((Entity)pEntity, pPos);
    }

    protected boolean isBodyVisible(AbstractClaySoldierRenderState livingEntity) {
        return super.isBodyVisible((LivingEntityRenderState)livingEntity) && !livingEntity.allProperties.isInvisible();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public static int shiftColorAngry(int color) {
        int red = Math.clamp((long)((color >> 16 & 0xFF) + 25), 0, 255);
        int green = Math.clamp((long)((color >> 8 & 0xFF) - 0), 0, 255);
        int blue = Math.clamp((long)((color & 0xFF) - 0), 0, 255);
        return red << 16 | green << 8 | blue;
    }

    private static class ClaySoldierItemInHandLayer
    extends ItemInHandLayer<AbstractClaySoldierRenderState, ClaySoldierModel> {
        public ClaySoldierItemInHandLayer(RenderLayerParent<AbstractClaySoldierRenderState, ClaySoldierModel> renderer) {
            super(renderer);
        }

        protected void renderArmWithItem(AbstractClaySoldierRenderState renderState, ItemStackRenderState itemStackRenderState, HumanoidArm arm, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
            if (arm == HumanoidArm.LEFT && renderState.offhandOccupied) {
                return;
            }
            if (arm == HumanoidArm.RIGHT && renderState.mainhandOccupied) {
                return;
            }
            super.renderArmWithItem((ArmedEntityRenderState)renderState, itemStackRenderState, arm, poseStack, bufferSource, packedLight);
        }
    }
}

