/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import java.util.function.Predicate;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ClayMobStatusRenderlayer<T extends ClayMobEntity, E extends LivingEntityRenderState, M extends EntityModel<E>>
extends RenderLayer<E, M> {
    private final Font font;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final Predicate<E> isInSittingPose;
    private final Predicate<E> showWorkStatus;
    private final Function<E, Component> getWorkStatus;
    private final Function<E, Vec3> attachmentPoint;

    public ClayMobStatusRenderlayer(MobRenderer<T, E, M> renderer, EntityRenderDispatcher entityRenderDispatcher, Predicate<E> isInSittingPose, Predicate<E> showWorkStatus, Function<E, Component> getWorkStatus, Function<E, Vec3> attachmentPoint) {
        super(renderer);
        this.entityRenderDispatcher = entityRenderDispatcher;
        this.font = renderer.getFont();
        this.isInSittingPose = isInSittingPose;
        this.showWorkStatus = showWorkStatus;
        this.getWorkStatus = getWorkStatus;
        this.attachmentPoint = attachmentPoint;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, E clayMob, float yRot, float xRot) {
        if (!this.showWorkStatus.test(clayMob)) {
            return;
        }
        Component workStatus = this.getWorkStatus.apply(clayMob);
        if (workStatus == null) {
            return;
        }
        PoseStack.Pose lastPose = poseStack.last().copy();
        poseStack.popPose();
        this.renderStatus(clayMob, poseStack, buffer, packedLight, workStatus);
        poseStack.pushPose();
        poseStack.setIdentity();
        poseStack.mulPose(lastPose.pose());
    }

    private void renderStatus(E soldier, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, Component workStatus) {
        pPoseStack.pushPose();
        pPoseStack.scale(0.5f, 0.5f, 0.5f);
        if (!this.isInSittingPose.test(soldier)) {
            pPoseStack.translate(0.0, 0.45, 0.0);
        } else {
            pPoseStack.translate(0.0, 0.35, 0.0);
        }
        pPoseStack.scale(0.5f, 0.5f, 0.5f);
        pPoseStack.translate(0.0, 0.45, 0.0);
        this.renderStatusName(soldier, workStatus, pPoseStack, pBuffer, pPackedLight);
        pPoseStack.popPose();
    }

    private void renderStatusName(E renderState, Component displayName, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Vec3 vec3 = this.attachmentPoint.apply(renderState);
        if (vec3 != null) {
            boolean flag = !((LivingEntityRenderState)renderState).isDiscrete;
            poseStack.pushPose();
            poseStack.translate(vec3.x, vec3.y + 0.5, vec3.z);
            poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
            poseStack.scale(0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = poseStack.last().pose();
            float f = (float)(-this.font.width((FormattedText)displayName)) / 2.0f;
            int backGroundAlpha = (int)(Minecraft.getInstance().options.getBackgroundOpacity(0.25f) * 255.0f) << 24;
            this.font.drawInBatch(displayName, f, 0.0f, -2130706433, false, matrix4f, buffer, flag ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, backGroundAlpha, packedLight);
            if (flag) {
                this.font.drawInBatch(displayName, f, 0.0f, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, LightTexture.lightCoordsWithEmission((int)packedLight, (int)2));
            }
            poseStack.popPose();
        }
    }
}

