/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.bumblebee.claysoldiers.entity.client.renderstates.AbstractClaySoldierRenderState;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.Nullable;

public class ClaySoldierModel
extends HumanoidModel<AbstractClaySoldierRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier"), "main");
    private static final float SCALE = 0.25f;
    protected static final CubeDeformation SHRINK_DEFORMATION = new CubeDeformation(0.25f, 0.25f, 0.25f);
    public static final String BAMBOO_STICK_NAME = "bamboo_stick";
    @Nullable
    public final ModelPart bambooStick;

    public ClaySoldierModel(ModelPart pRoot) {
        super(pRoot);
        this.bambooStick = pRoot.hasChild(BAMBOO_STICK_NAME) ? pRoot.getChild(BAMBOO_STICK_NAME) : null;
    }

    public void hideBambooStick() {
        if (this.bambooStick != null) {
            this.bambooStick.visible = false;
        }
    }

    public static LayerDefinition createSoldierLayer() {
        return LayerDefinition.create((MeshDefinition)ClaySoldierModel.createSoldierMesh(SHRINK_DEFORMATION, 0.0f), (int)64, (int)64);
    }

    protected static MeshDefinition createSoldierMesh(CubeDeformation cubeDeformation, float pYOffset) {
        MeshDefinition meshDefinition = ClaySoldierModel.createMesh((CubeDeformation)cubeDeformation, (float)pYOffset);
        PartDefinition partdefinition = meshDefinition.getRoot();
        partdefinition.addOrReplaceChild(BAMBOO_STICK_NAME, CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, -16.0f, -6.0f, 2.0f, 12.0f, 2.0f, cubeDeformation, 0.25f, 0.25f), PartPose.offset((float)0.0f, (float)pYOffset, (float)0.0f));
        return meshDefinition;
    }

    public void setupAnim(AbstractClaySoldierRenderState claySoldier) {
        super.setupAnim((HumanoidRenderState)claySoldier);
        if (claySoldier.isZombie) {
            AnimationUtils.animateZombieArms((ModelPart)this.leftArm, (ModelPart)this.rightArm, (boolean)claySoldier.isAggressive, (float)claySoldier.attackTime, (float)claySoldier.ageInTicks);
        }
        this.animateArms(claySoldier);
        this.setUpRidingPose(claySoldier);
        this.setSittingPose(claySoldier);
        if (this.bambooStick != null) {
            this.bambooStick.copyFrom(this.getHead());
            this.bambooStick.visible = false;
        }
    }

    private void animateArms(AbstractClaySoldierRenderState claySoldier) {
        boolean left;
        boolean isRightHanded = claySoldier.mainArm == HumanoidArm.RIGHT;
        boolean right = isRightHanded ? claySoldier.hasShieldInHand(InteractionHand.MAIN_HAND) : claySoldier.hasShieldInHand(InteractionHand.OFF_HAND);
        boolean bl = left = isRightHanded ? claySoldier.hasShieldInHand(InteractionHand.OFF_HAND) : claySoldier.hasShieldInHand(InteractionHand.MAIN_HAND);
        if (right) {
            this.rightArm.xRot = -1.2822827f;
            this.rightArm.yRot = -0.5f;
        }
        if (left) {
            this.leftArm.xRot = -1.2822827f;
            this.leftArm.yRot = 0.5f;
        }
        if (claySoldier.isFallingWithGlider || !claySoldier.carriedItemStack.isEmpty()) {
            this.leftArm.xRot = (float)(-Math.PI);
            this.rightArm.xRot = (float)(-Math.PI);
            this.rightArm.yRot = 0.0f;
            this.leftArm.yRot = 0.0f;
        }
    }

    public void renderBambooStick(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay) {
        if (this.bambooStick == null) {
            return;
        }
        this.bambooStick.visible = true;
        this.bambooStick.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
        this.bambooStick.visible = false;
    }

    private void setUpRidingPose(AbstractClaySoldierRenderState claySoldier) {
        if (claySoldier.ridingPose == AbstractClaySoldierEntity.RidingPose.RABBIT) {
            this.setRabbitRidingPose();
        } else {
            this.body.z = 0.0f;
            this.head.z = 0.0f;
        }
    }

    private void setRabbitRidingPose() {
        this.body.y = 15.0f;
        this.body.z = 2.0f;
        this.body.xRot = 1.0471976f;
        this.head.y = 15.0f;
        this.head.z = 2.0f;
        this.leftArm.y = 16.0f;
        this.rightArm.y = 16.0f;
        this.leftArm.z = 3.5f;
        this.rightArm.z = 3.5f;
        this.leftLeg.y = 21.0f;
        this.rightLeg.y = 21.0f;
        this.leftLeg.z = 12.0f;
        this.rightLeg.z = 12.0f;
        this.leftLeg.xRot = -5.340708f;
        this.rightLeg.xRot = -5.340708f;
        this.leftLeg.yRot = 0.2f;
        this.rightLeg.yRot = -0.2f;
    }

    private void setSittingPose(AbstractClaySoldierRenderState claySoldier) {
        if (claySoldier.isInSittingPose && !claySoldier.isPassenger) {
            if (claySoldier.id % 2 == 0) {
                this.sittingPose1();
            } else {
                this.sittingPose2();
            }
        }
    }

    public void sittingPose1() {
        this.head.y = 7.5f;
        this.leftArm.y = 9.5f;
        this.rightArm.y = 9.5f;
        this.body.y = 7.5f;
        this.rightLeg.y = 22.0f;
        this.leftLeg.y = 22.0f;
        this.rightLeg.z = 1.8f;
        this.leftLeg.z = 1.8f;
        this.setLegSittingRot();
    }

    private void sittingPose2() {
        this.head.y = 11.0f;
        this.head.z = 5.0f;
        this.head.x = 0.01f;
        this.leftArm.y = 13.5f;
        this.rightArm.y = 13.5f;
        this.leftArm.z = 5.0f;
        this.rightArm.z = 5.0f;
        this.leftArm.xRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightArm.xRot = 0.0f;
        this.rightArm.yRot = 0.0f;
        this.rightArm.zRot = 0.0f;
        this.body.y = 11.0f;
        this.body.xRot = -0.6f;
        this.body.z = 5.5f;
        this.rightLeg.y = 22.0f;
        this.leftLeg.y = 22.0f;
        this.rightLeg.z = 1.3f;
        this.leftLeg.z = 1.3f;
        this.setLegSittingRot();
    }

    private void setLegSittingRot() {
        this.rightLeg.yRot = 0.31415927f;
        this.leftLeg.yRot = -0.31415927f;
        this.rightLeg.xRot = -1.4137167f;
        this.leftLeg.xRot = -1.4137167f;
    }
}

