/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.util.Locale;
import java.util.Objects;
import net.bumblebee.claysoldiers.entity.client.AbstractClaySoldierRenderer;
import net.bumblebee.claysoldiers.entity.client.renderstates.AbstractClaySoldierRenderState;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ClientClaySoldierEntity
extends AbstractClaySoldierEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private final AbstractClaySoldierRenderer renderer;
    private ColorHelper offsetColor = ColorHelper.EMPTY;
    private Holder.Reference<ClayMobTeam> clayMobTeamId;
    private ItemStack cachedPickResult;
    private float scale = 1.0f;
    private boolean waxed = false;
    public final WalkAnimationState fakeWalkState;

    private ClientClaySoldierEntity(EntityType<? extends AbstractClaySoldierEntity> pEntityType, BlockPos pos, WalkAnimationState fakeWalkState, Holder.Reference<ClayMobTeam> clayMobTeamId) {
        super(pEntityType, (Level)Minecraft.getInstance().level, AttackTypeProperty.NORMAL);
        this.fakeWalkState = fakeWalkState;
        this.clayMobTeamId = clayMobTeamId;
        this.renderer = ClientClaySoldierEntity.createRenderer(pEntityType, this);
        this.setLevelCallback(EntityInLevelCallback.NULL);
        this.setPosRaw(pos.getX(), pos.getY(), pos.getZ());
    }

    public static ClientClaySoldierEntity create(EntityType<? extends AbstractClaySoldierEntity> type, CompoundTag tag, BlockPos pos, WalkAnimationState state, Holder.Reference<ClayMobTeam> id, float size) {
        ClientClaySoldierEntity soldier = new ClientClaySoldierEntity(type, pos, state, id);
        soldier.waxed = tag.getBoolean("Waxed");
        soldier.readArmorSaveData(tag);
        soldier.offsetColor = ColorHelper.getFromTag("OffsetColor", tag);
        soldier.scale = size;
        return soldier;
    }

    public static ClientClaySoldierEntity createAsProjectile(WalkAnimationState state, Holder.Reference<ClayMobTeam> clayMobTeam) {
        return new ClientClaySoldierEntity(ModEntityTypes.CLAY_SOLDIER_ENTITY.get(), BlockPos.ZERO, state, clayMobTeam);
    }

    public void setUpCape() {
        this.moveCloak(0.0, 0.0, 0.0);
    }

    private static AbstractClaySoldierRenderer createRenderer(EntityType<? extends AbstractClaySoldierEntity> type, AbstractClaySoldierEntity soldier) {
        try {
            return Objects.requireNonNull((AbstractClaySoldierRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)soldier));
        }
        catch (ClassCastException | NullPointerException e) {
            LOGGER.error("Could not create Renderer for Type {}, {}", (Object)type.getDescriptionId(), (Object)e.getMessage());
            return null;
        }
    }

    public void render(float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (this.renderer != null) {
            this.yBodyRotO = 0.0f;
            this.yBodyRot = 0.0f;
            this.yHeadRotO = 0.0f;
            this.yHeadRot = 0.0f;
            this.yRotO = 0.0f;
            this.xRotO = 0.0f;
            AbstractClaySoldierRenderState renderState = (AbstractClaySoldierRenderState)this.renderer.createRenderState((Entity)this, partialTicks);
            renderState.walkAnimationPos = this.fakeWalkState.position();
            renderState.walkAnimationSpeed = this.fakeWalkState.speed();
            this.renderer.render(renderState, poseStack, buffer, packedLight);
        }
    }

    @NotNull
    public String toString() {
        return String.format(Locale.ROOT, "%s['%s', r='%s' w='%b', s='%.2f' x=%.2f, y=%.2f, z=%.2f]", new Object[]{this.getClass().getSimpleName(), this.getName().getString(), this.renderer, this.waxed, Float.valueOf(this.scale), this.getX(), this.getY(), this.getZ()});
    }

    @Override
    protected float sanitizeScale(float scale) {
        return this.scale;
    }

    @Override
    public boolean isWaxed() {
        return this.waxed;
    }

    @Override
    @NotNull
    public ClayMobTeam getClayTeam() {
        if (ClayMobTeamManger.isValidTeam(this.clayMobTeamId.key().location(), this.registryAccess())) {
            return (ClayMobTeam)this.clayMobTeamId.value();
        }
        this.clayMobTeamId = ClayMobTeamManger.getDefault((HolderLookup.Provider)this.registryAccess());
        return (ClayMobTeam)this.clayMobTeamId.value();
    }

    @Override
    public ItemStack getPickResult() {
        if (ClayMobTeamManger.isValidTeam(this.clayMobTeamId.key().location(), this.level().registryAccess())) {
            if (this.cachedPickResult == null) {
                this.cachedPickResult = ClayMobTeamManger.createStackForTeam(this.clayMobTeamId.key().location(), (HolderLookup.Provider)this.level().registryAccess());
            }
            return this.cachedPickResult;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ResourceLocation getClayTeamType() {
        return this.clayMobTeamId.key().location();
    }

    @Override
    public ColorHelper getOffsetColor() {
        return this.offsetColor;
    }

    @Override
    @Nullable
    public Component getWorkStatus() {
        return null;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
    }

    public boolean isPassenger() {
        return false;
    }

    @Nullable
    public Entity getVehicle() {
        return null;
    }

    public boolean isCrouching() {
        return false;
    }

    @Override
    public void tick() {
    }

    public float getYRot() {
        return 0.0f;
    }

    public void setYRot(float yRot) {
    }

    public float getXRot() {
        return 0.0f;
    }

    public void setXRot(float xRot) {
    }

    public boolean isInWater() {
        return false;
    }
}

