/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.bumblebee.claysoldiers.entity.client.renderstates.ClayMobRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public abstract class SlimeRootLayer<T extends ClayMobRenderState, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();

    public SlimeRootLayer(RenderLayerParent<T, M> pRenderer) {
        super(pRenderer);
    }

    protected void renderSlimeRoot(PoseStack poseStack, MultiBufferSource bufferSource, T clayMob, int packedLight) {
        if (((ClayMobRenderState)((Object)clayMob)).slimeRoot && !((ClayMobRenderState)((Object)clayMob)).isPassenger) {
            poseStack.pushPose();
            this.scalePoseStackRoot(poseStack);
            this.itemRenderer.renderStatic(Items.SLIME_BLOCK.getDefaultInstance(), ItemDisplayContext.FIXED, packedLight, ((ClayMobRenderState)((Object)clayMob)).lightLevel, poseStack, bufferSource, (Level)Minecraft.getInstance().level, 1);
            poseStack.popPose();
        }
    }

    protected void scalePoseStackRoot(PoseStack poseStack) {
        poseStack.scale(1.5f, 1.5f, 1.5f);
        poseStack.translate(0.0f, 0.8f, 0.0f);
    }
}

