/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.accesories;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.function.Function;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.armor.SoldierMultiWearable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.IAccessoryRenderLayer;
import net.bumblebee.claysoldiers.datamap.armor.accessories.RenderableAccessory;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierModel;
import net.bumblebee.claysoldiers.entity.client.accesories.ClaySoldierCapeModel;
import net.bumblebee.claysoldiers.entity.client.accesories.ClaySoldierShieldModel;
import net.bumblebee.claysoldiers.entity.client.renderstates.AbstractClaySoldierRenderState;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.world.level.block.SkullBlock;
import org.jetbrains.annotations.Nullable;

public class AccessoryRenderLayer
extends RenderLayer<AbstractClaySoldierRenderState, ClaySoldierModel>
implements IAccessoryRenderLayer {
    public final ClaySoldierCapeModel capeModel;
    public final ClaySoldierShieldModel shieldModel;
    public final ItemInHandRenderer itemInHandRenderer;
    private final Function<SkullBlock.Type, SkullModelBase> modelByType;
    private final EquipmentAssetManager equipmentAssetManager;

    public AccessoryRenderLayer(RenderLayerParent<AbstractClaySoldierRenderState, ClaySoldierModel> pRendererParent, EntityModelSet entityModelSet, EquipmentAssetManager equipmentAssetManager) {
        super(pRendererParent);
        this.capeModel = new ClaySoldierCapeModel(entityModelSet.bakeLayer(ClaySoldierCapeModel.LAYER_LOCATION));
        this.itemInHandRenderer = Minecraft.getInstance().gameRenderer.itemInHandRenderer;
        this.modelByType = Util.memoize(type -> SkullBlockRenderer.createModel((EntityModelSet)entityModelSet, (SkullBlock.Type)type));
        this.shieldModel = new ClaySoldierShieldModel(entityModelSet.bakeLayer(ClaySoldierShieldModel.LAYER_LOCATION));
        this.equipmentAssetManager = equipmentAssetManager;
    }

    @Override
    public EquipmentAssetManager getEquipmentAssets() {
        return this.equipmentAssetManager;
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, AbstractClaySoldierRenderState claySoldier, float v, float v1) {
        HashMap map = new HashMap();
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            SoldierMultiWearable multi = this.getMulti(claySoldier, slot);
            if (multi == null) continue;
            map.putAll(multi.getAccessories());
        }
        for (RenderableAccessory acc : map.values()) {
            acc.render(this, pPoseStack, pBuffer, pPackedLight, claySoldier.accessoryRenderState);
        }
    }

    @Override
    @Nullable
    public SkullModelBase getSkullBase(SkullBlock.Type type) {
        return this.modelByType.apply(type);
    }

    @Override
    public ClaySoldierModel getSoldierModel() {
        return (ClaySoldierModel)this.getParentModel();
    }

    @Override
    public ClaySoldierCapeModel getCapeModel() {
        return this.capeModel;
    }

    @Override
    public ClaySoldierShieldModel getShieldModel() {
        return this.shieldModel;
    }

    @Nullable
    private SoldierMultiWearable getMulti(AbstractClaySoldierRenderState claySoldier, SoldierEquipmentSlot slot) {
        ItemStackWithEffect stackWithEffect = claySoldier.getItemBySlot(slot);
        if (stackWithEffect == null || stackWithEffect.isEmpty()) {
            return null;
        }
        return stackWithEffect.wearableEffectMap();
    }
}

