/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.accesories;

import net.bumblebee.claysoldiers.entity.client.ClaySoldierModel;
import net.bumblebee.claysoldiers.entity.client.renderstates.AbstractClaySoldierRenderState;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;

public class ClaySoldierCapeModel
extends ClaySoldierModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier_cape"), "cloak");
    private static final float SCALE = 0.25f;
    private static final CubeDeformation SHRINK_DEFORMATION = new CubeDeformation(0.25f, 0.25f, 0.25f);
    private static final String CLOAK = "cape";
    private final ModelPart cloak;

    public ClaySoldierCapeModel(ModelPart root) {
        super(root);
        this.cloak = this.body.getChild(CLOAK);
    }

    public static LayerDefinition createSoldierMesh() {
        MeshDefinition meshDefinition = ClaySoldierModel.createSoldierMesh(SHRINK_DEFORMATION, 0.0f);
        PartDefinition partdefinition = meshDefinition.getRoot();
        PartDefinition headPart = partdefinition.clearChild("head");
        headPart.clearChild("hat");
        partdefinition.clearChild("bamboo_stick");
        PartDefinition bodyPart = partdefinition.clearChild("body");
        partdefinition.clearChild("left_arm");
        partdefinition.clearChild("right_arm");
        partdefinition.clearChild("left_leg");
        partdefinition.clearChild("right_leg");
        bodyPart.addOrReplaceChild(CLOAK, CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -1.0f, 10.0f, 16.0f, 1.0f, CubeDeformation.NONE, 1.0f, 0.5f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)((float)Math.PI), (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    @Override
    public void setupAnim(AbstractClaySoldierRenderState pEntity) {
        super.setupAnim(pEntity);
        this.cloak.rotateBy(new Quaternionf().rotateY((float)(-Math.PI)).rotateX((6.0f + pEntity.capeLean / 2.0f + pEntity.capeFlap) * ((float)Math.PI / 180)).rotateZ(pEntity.capeLean2 / 2.0f * ((float)Math.PI / 180)).rotateY((180.0f - pEntity.capeLean2 / 2.0f) * ((float)Math.PI / 180)));
    }
}

