/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.horse;

import com.mojang.blaze3d.vertex.PoseStack;
import net.bumblebee.claysoldiers.datamap.horse.ClayHorseWearableProperties;
import net.bumblebee.claysoldiers.entity.client.ClayMobStatusRenderlayer;
import net.bumblebee.claysoldiers.entity.client.horse.ClayHorseArmorLayer;
import net.bumblebee.claysoldiers.entity.client.horse.ClayHorseModel;
import net.bumblebee.claysoldiers.entity.client.renderstates.ClayHorseRenderState;
import net.bumblebee.claysoldiers.entity.client.renderstates.ClayMobRenderState;
import net.bumblebee.claysoldiers.entity.horse.AbstractClayHorse;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.LivingEntity;

public class ClayHorseRenderer
extends MobRenderer<AbstractClayHorse, ClayHorseRenderState, ClayHorseModel> {
    private static final float SCALE = 0.25f;

    public ClayHorseRenderer(EntityRendererProvider.Context pContext) {
        super(pContext, (EntityModel)new ClayHorseModel(pContext.bakeLayer(ClayHorseModel.LAYER_LOCATION)), 0.1875f);
        this.addLayer(new ClayHorseArmorLayer((RenderLayerParent<ClayHorseRenderState, ClayHorseModel>)this, pContext.getModelSet(), pContext.getEquipmentAssets()));
        this.addLayer(new ClayMobStatusRenderlayer<AbstractClayHorse, ClayHorseRenderState, ClayHorseModel>(this, pContext.getEntityRenderDispatcher(), h -> h.isInSittingPose, h -> h.shouldShowWorkStatus, h -> h.workStatus, h -> h.statusAttachmentPoint));
    }

    public ResourceLocation getTextureLocation(ClayHorseRenderState clayHorseRenderState) {
        return clayHorseRenderState.variant.getTextureLocation();
    }

    public ClayHorseRenderState createRenderState() {
        return new ClayHorseRenderState();
    }

    public void extractRenderState(AbstractClayHorse clayHorse, ClayHorseRenderState clayHorseRenderState, float partialTick) {
        super.extractRenderState((LivingEntity)clayHorse, (LivingEntityRenderState)clayHorseRenderState, partialTick);
        clayHorseRenderState.isSaddled = clayHorse.isSaddled();
        clayHorseRenderState.isRidden = clayHorse.isVehicle();
        clayHorseRenderState.eatAnimation = clayHorse.getEatAnim(partialTick);
        clayHorseRenderState.standAnimation = clayHorse.getStandAnim(partialTick);
        clayHorseRenderState.feedingAnimation = clayHorse.getMouthAnim(partialTick);
        clayHorseRenderState.animateTail = clayHorse.tailCounter > 0;
        clayHorseRenderState.isInSittingPose = clayHorse.isInSittingPose();
        clayHorseRenderState.variant = clayHorse.getVariant();
        clayHorseRenderState.isPassenger = clayHorse.isPassenger();
        clayHorseRenderState.workStatus = clayHorse.getWorkStatus();
        clayHorseRenderState.shouldShowWorkStatus = ClayMobRenderState.shouldShowWorkStatus(clayHorse);
        clayHorseRenderState.clayHorseArmor = clayHorse.getArmor();
        ClayHorseWearableProperties effect = (ClayHorseWearableProperties)clayHorseRenderState.clayHorseArmor.effect();
        clayHorseRenderState.clayHorseArmorColor = effect == null ? -1 : effect.color().getColor((LivingEntity)clayHorse, partialTick);
        clayHorseRenderState.onGround = clayHorse.onGround();
        clayHorseRenderState.statusAttachmentPoint = clayHorse.getAttachments().get(EntityAttachment.NAME_TAG, 0, clayHorse.getYRot(partialTick));
    }

    protected void scale(ClayHorseRenderState renderState, PoseStack poseStack) {
        poseStack.scale(0.25f, 0.25f, 0.25f);
        if (renderState.isInSittingPose && !renderState.isPassenger) {
            poseStack.translate(0.0, 0.5, 0.0);
        }
        super.scale((LivingEntityRenderState)renderState, poseStack);
    }
}

