/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.renderstates;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.armor.SoldierMultiWearable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.AccessoryRenderState;
import net.bumblebee.claysoldiers.datamap.armor.accessories.RenderableAccessory;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.GliderRenderable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.SkullRenderable;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.client.renderstates.ClayMobRenderState;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMapReader;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AbstractClaySoldierRenderState
extends ClayMobRenderState {
    public boolean isZombie;
    public boolean isAggressive;
    public boolean hasShieldInOffhand;
    public boolean hasShieldInMainHand;
    public boolean isFallingWithGlider;
    public boolean veryAngry;
    public SoldierEquipmentSlot gliderSlot;
    public ItemStack carriedItemStack;
    public final ItemStackRenderState carriedItemRenderState = new ItemStackRenderState();
    public AbstractClaySoldierEntity.RidingPose ridingPose;
    public int id;
    public int skinVariantId;
    public boolean offhandOccupied;
    public boolean mainhandOccupied;
    public boolean isAlive;
    public boolean isFalling;
    public float fallFlyingTimeInTicks;
    public boolean isNightForVampire = false;
    public int previousTeamColor = -1;
    @Nullable
    public BossClaySoldierEntity.BossTypes bossType = null;
    public SoldierPropertyMapReader allProperties;
    public int offsetColor;
    private final Map<SoldierEquipmentSlot, ItemStackWithEffect> inventory = new EnumMap<SoldierEquipmentSlot, ItemStackWithEffect>(SoldierEquipmentSlot.class);
    public float capeFlap;
    public float capeLean;
    public float capeLean2;
    public float swelling;
    public AccessoryRenderState accessoryRenderState;

    public boolean hasShieldInHand(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? this.hasShieldInMainHand : this.hasShieldInOffhand;
    }

    public ItemStackWithEffect getItemBySlot(SoldierEquipmentSlot pSlot) {
        return this.inventory.get(pSlot);
    }

    public void setUpInventory(AbstractClaySoldierEntity claySoldierEntity) {
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            this.inventory.put(slot, claySoldierEntity.getItemBySlot(slot));
        }
    }

    public float fallFlyingScale() {
        return Mth.clamp((float)(this.fallFlyingTimeInTicks * this.fallFlyingTimeInTicks / 100.0f), (float)0.0f, (float)1.0f);
    }

    public static void extractCloakState(AbstractClaySoldierEntity claySoldierEntity, AbstractClaySoldierRenderState renderState, float partialTick) {
        double d0 = Mth.lerp((double)partialTick, (double)claySoldierEntity.xCloakO, (double)claySoldierEntity.xCloak) - Mth.lerp((double)partialTick, (double)claySoldierEntity.xo, (double)claySoldierEntity.getX());
        double d1 = Mth.lerp((double)partialTick, (double)claySoldierEntity.yCloakO, (double)claySoldierEntity.yCloak) - Mth.lerp((double)partialTick, (double)claySoldierEntity.yo, (double)claySoldierEntity.getY());
        double d2 = Mth.lerp((double)partialTick, (double)claySoldierEntity.zCloakO, (double)claySoldierEntity.zCloak) - Mth.lerp((double)partialTick, (double)claySoldierEntity.zo, (double)claySoldierEntity.getZ());
        float f = Mth.rotLerp((float)partialTick, (float)claySoldierEntity.yBodyRotO, (float)claySoldierEntity.yBodyRot);
        double d3 = Mth.sin((float)(f * ((float)Math.PI / 180)));
        double d4 = -Mth.cos((float)(f * ((float)Math.PI / 180)));
        renderState.capeFlap = (float)d1 * 10.0f;
        renderState.capeFlap = Mth.clamp((float)renderState.capeFlap, (float)-6.0f, (float)32.0f);
        renderState.capeLean = (float)(d0 * d3 + d2 * d4) * 100.0f;
        renderState.capeLean *= 1.0f - renderState.fallFlyingScale();
        renderState.capeLean = Mth.clamp((float)renderState.capeLean, (float)0.0f, (float)150.0f);
        renderState.capeLean2 = (float)(d0 * d4 - d2 * d3) * 100.0f;
        renderState.capeLean2 = Mth.clamp((float)renderState.capeLean2, (float)-20.0f, (float)20.0f);
        float f1 = Mth.lerp((float)partialTick, (float)claySoldierEntity.oBob, (float)claySoldierEntity.bob);
        float f2 = partialTick;
        renderState.capeFlap += Mth.sin((float)(f2 * 6.0f)) * 32.0f * f1;
    }

    public static void extractAccessoryRenderState(AbstractClaySoldierEntity claySoldierEntity, AbstractClaySoldierRenderState renderState, ItemModelResolver itemModelResolver) {
        AccessoryRenderState acc = new AccessoryRenderState();
        HashMap map = new HashMap();
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            SoldierMultiWearable multi = AbstractClaySoldierRenderState.getMulti(claySoldierEntity, slot);
            if (multi == null) continue;
            map.putAll(multi.getAccessories());
        }
        acc.renderableAccessories = map.values();
        for (RenderableAccessory accessory : acc.renderableAccessories) {
            if (accessory instanceof SkullRenderable) {
                SkullRenderable skullRenderable = (SkullRenderable)accessory;
                itemModelResolver.updateForLiving(acc.skullAccessory, skullRenderable.getHeadStack(), ItemDisplayContext.HEAD, false, (LivingEntity)claySoldierEntity);
                continue;
            }
            if (!(accessory instanceof GliderRenderable)) continue;
            GliderRenderable gliderRenderable = (GliderRenderable)accessory;
            itemModelResolver.updateForLiving(acc.gliderAccessory, gliderRenderable.getGliderStack(), ItemDisplayContext.HEAD, false, (LivingEntity)claySoldierEntity);
        }
        renderState.accessoryRenderState = acc;
        acc.renderStateFrom = renderState;
        acc.ageInTicks = renderState.ageInTicks;
        acc.chestEquipment = renderState.chestEquipment;
        acc.id = renderState.id;
        acc.offsetColor = renderState.offsetColor;
        acc.isFalling = renderState.isFalling;
        acc.isInSittingPose = renderState.isInSittingPose;
        acc.mainArm = renderState.mainArm;
        acc.hasShieldInMainHand = renderState.hasShieldInMainHand;
        acc.hasShieldInOffhand = renderState.hasShieldInOffhand;
        acc.wornHeadProfile = renderState.wornHeadProfile;
        acc.wornHeadAnimationPos = renderState.wornHeadAnimationPos;
        acc.overlayCords0 = LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)renderState, (float)0.0f);
    }

    @Nullable
    private static SoldierMultiWearable getMulti(AbstractClaySoldierEntity claySoldier, SoldierEquipmentSlot slot) {
        ItemStackWithEffect stackWithEffect = claySoldier.getItemBySlot(slot);
        if (stackWithEffect == null || stackWithEffect.isEmpty()) {
            return null;
        }
        return stackWithEffect.wearableEffectMap();
    }
}

