/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.renderstates;

import net.bumblebee.claysoldiers.ClaySoldiersClient;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class ClayMobRenderState
extends HumanoidRenderState {
    public boolean slimeRoot = false;
    public boolean isInSittingPose = false;
    public boolean isWaxed = false;
    public boolean isUsingPoi = false;
    public ClayMobTeam clayTeam;
    public int clayTeamColor;
    public Component workStatus;
    public boolean shouldShowStatus;
    public int lightLevel;
    public Vec3 statusAttachmentPoint;

    public static boolean shouldShowWorkStatus(ClayMobEntity clayMob) {
        return Minecraft.getInstance().player.equals((Object)clayMob.getClayTeamOwner()) && ClaySoldiersClient.hasPlayerClayGogglesEquipped() && !clayMob.isVehicle();
    }

    public static void extractClayMobRenderState(ClayMobEntity clayMob, ClayMobRenderState clayMobRenderState, float partialTick) {
        clayMobRenderState.slimeRoot = clayMob.isSlimeRooted();
        clayMobRenderState.isInSittingPose = clayMob.isInSittingPose();
        clayMobRenderState.isWaxed = clayMob.isWaxed();
        clayMobRenderState.isUsingPoi = clayMob.usingPoi();
        clayMobRenderState.clayTeam = clayMob.getClayTeam();
        clayMobRenderState.clayTeamColor = clayMobRenderState.clayTeam.getColor((LivingEntity)clayMob, partialTick);
        clayMobRenderState.workStatus = clayMob.getWorkStatus();
        clayMobRenderState.shouldShowStatus = ClayMobRenderState.shouldShowWorkStatus(clayMob);
        clayMobRenderState.lightLevel = ClayMobRenderState.getLightLevel((Entity)clayMob);
        clayMobRenderState.statusAttachmentPoint = clayMob.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, clayMob.getYRot(partialTick));
    }

    private static int getLightLevel(Entity pEntity) {
        BlockPos pos = pEntity.getOnPos();
        int bLight = pEntity.level().getBrightness(LightLayer.BLOCK, pos);
        int sLight = pEntity.level().getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

