/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.undead;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.bumblebee.claysoldiers.entity.VampiricClayMob;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierModel;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierRenderer;
import net.bumblebee.claysoldiers.entity.client.renderstates.AbstractClaySoldierRenderState;
import net.bumblebee.claysoldiers.entity.client.undead.SoldierSuitLayer;
import net.bumblebee.claysoldiers.entity.client.undead.VampireEyesLayer;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;

public class VampireClaySoldierRenderer
extends ClaySoldierRenderer {
    public VampireClaySoldierRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.addLayer(SoldierSuitLayer.vampire((RenderLayerParent<AbstractClaySoldierRenderState, ClaySoldierModel>)this));
        this.addLayer(VampireEyesLayer.forVampiricClayMob((RenderLayerParent<AbstractClaySoldierRenderState, ClaySoldierModel>)this));
    }

    @Override
    protected void renderModel(AbstractClaySoldierRenderState soldier, PoseStack pPoseStack, VertexConsumer vertexConsumer, int pPackedLight, int overlayCords, int color, int alpha) {
        super.renderModel(soldier, pPoseStack, vertexConsumer, pPackedLight, overlayCords, VampireClaySoldierRenderer.shiftColor(color), alpha);
    }

    @Override
    public void extractRenderState(AbstractClaySoldierEntity claySoldierEntity, AbstractClaySoldierRenderState claySoldierRenderState, float partialTick) {
        super.extractRenderState(claySoldierEntity, claySoldierRenderState, partialTick);
        if (claySoldierEntity instanceof VampiricClayMob) {
            VampiricClayMob vampire = (VampiricClayMob)((Object)claySoldierEntity);
            claySoldierRenderState.isNightForVampire = vampire.isNightForVampire();
        }
    }

    public static int shiftColor(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)((float)red + (float)(255 - red) * 0.3f);
        green = (int)((float)green + (float)(255 - green) * 0.3f);
        blue = (int)((float)blue + (float)(255 - blue) * 0.3f);
        return red << 16 | green << 8 | blue;
    }
}

