/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.undead;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierModel;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierRenderer;
import net.bumblebee.claysoldiers.entity.client.renderstates.AbstractClaySoldierRenderState;
import net.bumblebee.claysoldiers.entity.client.undead.SoldierSuitLayer;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.ZombieClaySoldierEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.LivingEntity;

public class ZombieClaySoldierRenderer
extends ClaySoldierRenderer {
    public ZombieClaySoldierRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.addLayer(SoldierSuitLayer.zombie((RenderLayerParent<AbstractClaySoldierRenderState, ClaySoldierModel>)this));
    }

    @Override
    protected void renderModel(AbstractClaySoldierRenderState soldier, PoseStack pPoseStack, VertexConsumer vertexConsumer, int pPackedLight, int overlayCords, int color, int alpha) {
        super.renderModel(soldier, pPoseStack, vertexConsumer, pPackedLight, overlayCords, ZombieClaySoldierRenderer.shiftColor(color), alpha);
    }

    @Override
    public void extractRenderState(AbstractClaySoldierEntity claySoldierEntity, AbstractClaySoldierRenderState claySoldierRenderState, float partialTick) {
        super.extractRenderState(claySoldierEntity, claySoldierRenderState, partialTick);
        if (claySoldierEntity instanceof ZombieClaySoldierEntity) {
            ZombieClaySoldierEntity zombie = (ZombieClaySoldierEntity)claySoldierEntity;
            claySoldierRenderState.previousTeamColor = zombie.getPreviousTeam().getColor((LivingEntity)claySoldierEntity, partialTick);
        }
    }

    public static int shiftColor(int color) {
        int red = Math.clamp((long)((color >> 16 & 0xFF) - 25), 0, 255);
        int green = Math.clamp((long)((color >> 8 & 0xFF) + 25), 0, 255);
        int blue = Math.clamp((long)((color & 0xFF) - 25), 0, 255);
        return red << 16 | green << 8 | blue;
    }

    @Override
    protected int getVariantForColor(AbstractClaySoldierRenderState claySoldier) {
        return claySoldier.previousTeamColor != -1 ? claySoldier.previousTeamColor : super.getVariantForColor(claySoldier);
    }
}

