/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.wraith;

import com.mojang.blaze3d.vertex.PoseStack;
import net.bumblebee.claysoldiers.entity.client.renderstates.ClayWraithRenderState;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class WraithModel
extends EntityModel<ClayWraithRenderState>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"wraith_clay_soldier"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart head;

    public WraithModel(ModelPart pRoot) {
        super(pRoot.getChild("root"), RenderType::entityTranslucentEmissive);
        this.root = pRoot.getChild("root");
        this.body = this.root.getChild("body");
        this.rightArm = this.body.getChild("right_arm");
        this.leftArm = this.body.getChild("left_arm");
        this.rightWing = this.body.getChild("right_wing");
        this.leftWing = this.body.getChild("left_wing");
        this.head = this.root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-2.5f, (float)0.0f));
        partdefinition1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 10).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 16).addBox(-2.0f, 0.0f, -1.0f, 4.0f, 6.0f, 2.0f, new CubeDeformation(-0.2f)), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        partdefinition2.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(23, 0).addBox(-1.25f, -0.5f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)-1.75f, (float)0.25f, (float)0.0f));
        partdefinition2.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(23, 7).addBox(-0.75f, -0.5f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offset((float)1.75f, (float)0.25f, (float)0.0f));
        partdefinition2.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(16, 14).mirror().addBox(0.0f, 0.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.5f, (float)1.0f, (float)1.0f));
        partdefinition2.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(16, 14).addBox(0.0f, 0.0f, 0.0f, 0.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)1.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(ClayWraithRenderState p_362388_) {
        super.setupAnim((EntityRenderState)p_362388_);
        this.head.yRot = p_362388_.yRot * ((float)Math.PI / 180);
        this.head.xRot = p_362388_.xRot * ((float)Math.PI / 180);
        float f = Mth.cos((float)(p_362388_.ageInTicks * 5.5f * ((float)Math.PI / 180))) * 0.1f;
        this.rightArm.zRot = 0.62831855f + f;
        this.leftArm.zRot = -(0.62831855f + f);
        if (p_362388_.isCharging) {
            this.body.xRot = 0.0f;
            this.setArmsCharging(!p_362388_.rightHandItem.isEmpty(), !p_362388_.leftHandItem.isEmpty(), f);
        } else {
            this.body.xRot = 0.15707964f;
        }
        this.leftWing.yRot = 1.0995574f + Mth.cos((float)(p_362388_.ageInTicks * 45.836624f * ((float)Math.PI / 180))) * ((float)Math.PI / 180) * 16.2f;
        this.rightWing.yRot = -this.leftWing.yRot;
        this.leftWing.xRot = 0.47123888f;
        this.leftWing.zRot = -0.47123888f;
        this.rightWing.xRot = 0.47123888f;
        this.rightWing.zRot = 0.47123888f;
    }

    private void setArmsCharging(boolean rightArm, boolean leftArm, float chargeAmount) {
        if (!rightArm && !leftArm) {
            this.rightArm.xRot = -1.2217305f;
            this.rightArm.yRot = 0.2617994f;
            this.rightArm.zRot = -0.47123888f - chargeAmount;
            this.leftArm.xRot = -1.2217305f;
            this.leftArm.yRot = -0.2617994f;
            this.leftArm.zRot = 0.47123888f + chargeAmount;
        } else {
            if (rightArm) {
                this.rightArm.xRot = 3.6651914f;
                this.rightArm.yRot = 0.2617994f;
                this.rightArm.zRot = -0.47123888f - chargeAmount;
            }
            if (leftArm) {
                this.leftArm.xRot = 3.6651914f;
                this.leftArm.yRot = -0.2617994f;
                this.leftArm.zRot = 0.47123888f + chargeAmount;
            }
        }
    }

    public void translateToHand(HumanoidArm p_259770_, PoseStack p_260351_) {
        boolean flag = p_259770_ == HumanoidArm.RIGHT;
        ModelPart modelpart = flag ? this.rightArm : this.leftArm;
        this.root.translateAndRotate(p_260351_);
        this.body.translateAndRotate(p_260351_);
        modelpart.translateAndRotate(p_260351_);
        p_260351_.scale(0.55f, 0.55f, 0.55f);
        this.offsetStackPosition(p_260351_, flag);
    }

    private void offsetStackPosition(PoseStack poseStack, boolean rightSide) {
        if (rightSide) {
            poseStack.translate(0.046875, -0.15625, 0.078125);
        } else {
            poseStack.translate(-0.046875, -0.15625, 0.078125);
        }
    }
}

