/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.wraith;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.bumblebee.claysoldiers.entity.ClayWraithEntity;
import net.bumblebee.claysoldiers.entity.client.ClayMobStatusRenderlayer;
import net.bumblebee.claysoldiers.entity.client.renderstates.ClayMobRenderState;
import net.bumblebee.claysoldiers.entity.client.renderstates.ClayWraithRenderState;
import net.bumblebee.claysoldiers.entity.client.wraith.WraithModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class WraithRenderer
extends MobRenderer<ClayWraithEntity, ClayWraithRenderState, WraithModel> {
    private static final ResourceLocation WRAITH_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/entity/clay_wraith/wraith.png");
    private static final ResourceLocation WRAITH_CHARGING_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/illager/vex_charging.png");
    private static final float SCALE = 0.5f;
    private static final int DEFAULT_ALPHA = 179;

    public WraithRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new WraithModel(context.bakeLayer(WraithModel.LAYER_LOCATION)), 0.15f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.addLayer(new ClayMobStatusRenderlayer<ClayWraithEntity, ClayWraithRenderState, WraithModel>(this, context.getEntityRenderDispatcher(), w -> w.isInSittingPose, w -> w.shouldShowWorkStatus, w -> w.workStatus, w -> w.statusAttachmentPoint));
    }

    protected void scale(ClayWraithRenderState pLivingEntity, PoseStack pPoseStack) {
        pPoseStack.scale(0.5f, 0.5f, 0.5f);
    }

    public ClayWraithRenderState createRenderState() {
        return new ClayWraithRenderState();
    }

    public void extractRenderState(ClayWraithEntity clayWraithEntity, ClayWraithRenderState clayWraithRenderState, float partialTick) {
        super.extractRenderState((LivingEntity)clayWraithEntity, (LivingEntityRenderState)clayWraithRenderState, partialTick);
        clayWraithRenderState.clayTeamColor = clayWraithEntity.getClayTeam().getColor((LivingEntity)clayWraithEntity, partialTick);
        clayWraithRenderState.lifePoint = clayWraithEntity.getLifePoint();
        clayWraithRenderState.hasLimitedLife = clayWraithEntity.hasLimitedLife();
        clayWraithRenderState.isInSittingPose = clayWraithEntity.isInSittingPose();
        clayWraithRenderState.shouldShowWorkStatus = ClayMobRenderState.shouldShowWorkStatus(clayWraithEntity);
        clayWraithRenderState.workStatus = clayWraithEntity.getWorkStatus();
        clayWraithRenderState.statusAttachmentPoint = clayWraithEntity.getAttachments().get(EntityAttachment.NAME_TAG, 0, clayWraithEntity.getYRot(partialTick));
    }

    public ResourceLocation getTextureLocation(ClayWraithRenderState pEntity) {
        return WRAITH_LOCATION;
    }

    protected int getBlockLightLevel(ClayWraithEntity pEntity, BlockPos pPos) {
        return 15;
    }

    public void render(ClayWraithRenderState wraith, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Direction direction;
        poseStack.pushPose();
        if (wraith.hasPose(Pose.SLEEPING) && (direction = wraith.bedOrientation) != null) {
            float f = wraith.eyeHeight - 0.1f;
            poseStack.translate((float)(-direction.getStepX()) * f, 0.0f, (float)(-direction.getStepZ()) * f);
        }
        float f1 = wraith.scale;
        poseStack.scale(f1, f1, f1);
        this.setupRotations((LivingEntityRenderState)wraith, poseStack, wraith.bodyRot, f1);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale(wraith, poseStack);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        ((WraithModel)this.model).setupAnim(wraith);
        boolean flag1 = this.isBodyVisible((LivingEntityRenderState)wraith);
        boolean flag = !flag1 && !wraith.isInvisibleToPlayer;
        RenderType rendertype = this.getRenderType((LivingEntityRenderState)wraith, flag1, flag, wraith.appearsGlowing);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = buffer.getBuffer(rendertype);
            int overlay = WraithRenderer.getOverlayCoords((LivingEntityRenderState)wraith, (float)this.getWhiteOverlayProgress((LivingEntityRenderState)wraith));
            int color = ARGB.color((int)this.getAlpha(wraith), (int)wraith.clayTeamColor);
            ((WraithModel)this.model).renderToBuffer(poseStack, vertexconsumer, packedLight, overlay, color);
        }
        if (this.shouldRenderLayers((LivingEntityRenderState)wraith)) {
            for (RenderLayer renderlayer : this.layers) {
                renderlayer.render(poseStack, buffer, packedLight, (EntityRenderState)wraith, wraith.yRot, wraith.xRot);
            }
        }
        poseStack.popPose();
    }

    private int getAlpha(ClayWraithRenderState wraith) {
        if (wraith.hasLimitedLife) {
            return Math.max(0, wraith.lifePoint * 3 - 10);
        }
        return 179;
    }
}

