/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal;

import java.util.Iterator;
import java.util.List;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface AlertOthersGoal {
    public static final AlertOthersGoal INSTANCE = new AlertOthersGoal(){};

    default public void alertOthersSoldiers(AbstractClaySoldierEntity self) {
        double d0 = this.getFollowDistance(self) / 2.0;
        AABB aabb = AABB.unitCubeFromLowerCorner((Vec3)self.position()).inflate(d0, 6.0, d0);
        List list = self.level().getEntitiesOfClass(AbstractClaySoldierEntity.class, aabb, EntitySelector.NO_SPECTATORS);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractClaySoldierEntity otherSoldiers = (AbstractClaySoldierEntity)iterator.next();
            if (self == otherSoldiers || otherSoldiers.getTarget() != null && self.getAttackType() != AttackTypeProperty.KING || self.getLastHurtByMob() == null || otherSoldiers.isAlliedTo((Entity)self.getLastHurtByMob()) || !otherSoldiers.fightsBack() || otherSoldiers.getAttackType().isRoyalty()) continue;
            this.alertOther(otherSoldiers, self.getLastHurtByMob());
        }
        return;
    }

    default public void alertOther(AbstractClaySoldierEntity pMob, LivingEntity pTarget) {
        pMob.setTarget(pTarget);
    }

    default public double getFollowDistance(AbstractClaySoldierEntity self) {
        return self.getAttributeValue(Attributes.FOLLOW_RANGE);
    }
}

