/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal;

import java.util.EnumSet;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class ClayMobSitGoal
extends Goal {
    private static final int DELAY_BEFORE_LAST_ATTACK = 60;
    protected final ClayMobEntity clayMobEntity;

    public ClayMobSitGoal(ClayMobEntity clayMobEntity) {
        this.clayMobEntity = clayMobEntity;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    protected boolean isCurrentlyFighting() {
        return this.clayMobEntity.getLastHurtByMobTimestamp() + 60 > this.clayMobEntity.tickCount;
    }

    public boolean canContinueToUse() {
        if (this.isCurrentlyFighting()) {
            return false;
        }
        return this.clayMobEntity.isOrderedToSit();
    }

    public boolean canUse() {
        if (this.isCurrentlyFighting()) {
            return false;
        }
        Player owner = this.clayMobEntity.getClayTeamOwner();
        if (owner == null) {
            return false;
        }
        if (!this.clayMobEntity.isOrderedToSit()) {
            return false;
        }
        if (owner.getLastHurtByMob() != null && this.clayMobEntity.distanceToSqr((Entity)owner) < 144.0) {
            return false;
        }
        Entity vehicle = this.clayMobEntity.getVehicle();
        if (vehicle != null) {
            return !vehicle.isInWaterOrBubble();
        }
        if (this.clayMobEntity.isInWaterOrBubble()) {
            return false;
        }
        return this.clayMobEntity.onGround();
    }

    public void start() {
        this.clayMobEntity.getNavigation().stop();
        Entity vehicle = this.clayMobEntity.getVehicle();
        this.clayMobEntity.setInSittingPose(true);
        if (vehicle == null) {
            this.clayMobEntity.setPose(Pose.SITTING);
            return;
        }
        if (vehicle instanceof ClayMobEntity) {
            ClayMobEntity clayVehicle = (ClayMobEntity)vehicle;
            clayVehicle.setPose(Pose.SITTING);
            clayVehicle.setInSittingPose(true);
        }
    }

    public void stop() {
        this.clayMobEntity.setInSittingPose(false);
        this.clayMobEntity.setPose(Pose.STANDING);
        Entity entity = this.clayMobEntity.getVehicle();
        if (entity instanceof ClayMobEntity) {
            ClayMobEntity clayVehicle = (ClayMobEntity)entity;
            clayVehicle.setPose(Pose.STANDING);
            clayVehicle.setInSittingPose(false);
        }
    }
}

