/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal;

import java.util.EnumSet;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.ai.goal.Goal;

public class ClaySodlierBreathAirGoal
extends Goal {
    private final AbstractClaySoldierEntity soldier;
    private boolean started = false;

    public ClaySodlierBreathAirGoal(AbstractClaySoldierEntity mob) {
        this.soldier = mob;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP));
    }

    public boolean canUse() {
        return this.started || this.soldierAbleToUse() && (this.soldier.getAirSupply() < 100 || this.alwaysUse());
    }

    public boolean canContinueToUse() {
        return this.started || this.soldierAbleToUse() && this.alwaysUse();
    }

    private boolean soldierAbleToUse() {
        return this.soldier.isInWater() && this.soldier.getFluidHeight(FluidTags.WATER) > this.soldier.getFluidJumpThreshold() && this.soldier.canSwim();
    }

    private boolean alwaysUse() {
        return this.soldier.getTarget() == null && !this.soldier.isInCombat() && this.soldier.allProperties().breathHoldDuration() < 1000;
    }

    public void start() {
        this.started = true;
    }

    public void tick() {
        if (this.soldier.getRandom().nextFloat() < 0.8f) {
            this.soldier.getJumpControl().jump();
        }
        if (this.soldier.getAirSupply() >= this.soldier.getMaxAirSupply()) {
            this.started = false;
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

