/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal;

import java.util.EnumSet;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class ClaySoldierMountGoal
extends Goal {
    protected final AbstractClaySoldierEntity claySoldier;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 10L;
    private static final int COOLDOWN_BETWEEN_CAN_ATTACKS = 2;

    public ClaySoldierMountGoal(AbstractClaySoldierEntity pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
        this.claySoldier = pMob;
        this.speedModifier = pSpeedModifier;
        this.followingTargetEvenIfNotSeen = pFollowingTargetEvenIfNotSeen;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.claySoldier.isPassenger()) {
            return false;
        }
        long gameTime = this.claySoldier.level().getGameTime();
        if (gameTime - this.lastCanUseCheck < 10L) {
            return false;
        }
        this.lastCanUseCheck = gameTime;
        LivingEntity target = this.claySoldier.getTarget();
        if (target == null) {
            return false;
        }
        if (!target.isAlive() || !this.claySoldier.canMountEntity(target, ClaySoldierMountGoal.getServerLevel((Entity)this.claySoldier))) {
            return false;
        }
        this.path = this.claySoldier.getNavigation().createPath((Entity)target, 0);
        if (this.path != null) {
            return true;
        }
        return this.claySoldier.isWithinMeleeAttackRange(target);
    }

    public boolean canContinueToUse() {
        if (this.claySoldier.isPassenger()) {
            return false;
        }
        LivingEntity livingentity = this.claySoldier.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.isAlive() || !this.claySoldier.canMountEntity(livingentity, ClaySoldierMountGoal.getServerLevel((Entity)this.claySoldier))) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.claySoldier.getNavigation().isDone();
        }
        return this.claySoldier.isWithinRestriction(livingentity.blockPosition());
    }

    public void start() {
        this.claySoldier.getNavigation().moveTo(this.path, this.speedModifier);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void stop() {
        LivingEntity livingentity = this.claySoldier.getTarget();
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
            this.claySoldier.setTarget(null);
        }
        this.claySoldier.getNavigation().stop();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        LivingEntity livingentity = this.claySoldier.getTarget();
        if (livingentity != null) {
            this.claySoldier.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.claySoldier.getSensing().hasLineOfSight((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.claySoldier.getRandom().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingentity.getX();
                this.pathedTargetY = livingentity.getY();
                this.pathedTargetZ = livingentity.getZ();
                this.ticksUntilNextPathRecalculation = 2;
                double distanceTarget = this.claySoldier.distanceToSqr((Entity)livingentity);
                if (distanceTarget > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (distanceTarget > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.claySoldier.getNavigation().moveTo((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.tryRiding(livingentity);
        }
    }

    protected void tryRiding(LivingEntity pTarget) {
        if (this.canTryToRide(pTarget)) {
            this.claySoldier.startRiding((Entity)pTarget);
            this.claySoldier.setTarget(null);
            this.resetRideCooldown();
        }
    }

    protected void resetRideCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(2);
    }

    protected boolean isTimeToTryToRide() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canTryToRide(LivingEntity pEntity) {
        return this.isTimeToTryToRide() && this.claySoldier.isWithinMeleeAttackRange(pEntity) && this.claySoldier.getSensing().hasLineOfSight((Entity)pEntity);
    }
}

