/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.target;

import java.util.EnumSet;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class ClayMobOwnerHurtByTarget
extends TargetGoal {
    private final ClayMobEntity clayMob;
    private LivingEntity ownerLastHurtBy;
    private int timestamp;

    public ClayMobOwnerHurtByTarget(ClayMobEntity clayMob) {
        super((Mob)clayMob, false);
        this.clayMob = clayMob;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        Player owner = this.clayMob.getClayTeamOwner();
        if (owner != null && !this.clayMob.isOrderedToSit()) {
            this.ownerLastHurtBy = owner.getLastHurtByMob();
            int lastHurtByMobTimestamp = owner.getLastHurtByMobTimestamp();
            return lastHurtByMobTimestamp != this.timestamp && this.canAttack(this.ownerLastHurtBy, TargetingConditions.DEFAULT) && this.clayMob.wantsToAttack(this.ownerLastHurtBy, (LivingEntity)owner);
        }
        return false;
    }

    public void start() {
        this.mob.setTarget(this.ownerLastHurtBy);
        Player livingentity = this.clayMob.getClayTeamOwner();
        if (livingentity != null) {
            this.timestamp = livingentity.getLastHurtByMobTimestamp();
        }
        super.start();
    }
}

