/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.entity.goal.workgoal.AbstractWorkGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;

public class PickUpItemsGoal
extends AbstractWorkGoal {
    public static final String PICK_UP_ITEM_LANG = "clay_soldier_work.%s.job.%s".formatted("csr", "pick_up_items");
    private static final Predicate<ItemEntity> ALLOWED_ITEMS = itemEntity -> !itemEntity.hasPickUpDelay() && itemEntity.isAlive();
    private static final float VERTICAL_SEARCH_RANGE = 8.0f;

    public PickUpItemsGoal(AbstractClaySoldierEntity soldier, Supplier<WorkSelectorGoal> workSelector) {
        super(soldier, workSelector);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.isOnBreak()) {
            return false;
        }
        return !this.getItemsInArea().isEmpty() || !this.soldier.getCarriedStack().isEmpty();
    }

    public boolean canContinueToUse() {
        if (this.isOnBreak()) {
            return false;
        }
        return !this.getItemsInArea().isEmpty();
    }

    public void pushToWardsItem(ItemEntity itemEntity) {
        PickUpItemsGoal.pushToWardsItem(this.soldier, itemEntity);
    }

    public void tick() {
        if (this.soldier.getCarriedStack().isEmpty()) {
            this.setStatus((byte)1);
            List<ItemEntity> list = this.getItemsInArea();
            if (this.soldier.getItemBySlot(SoldierEquipmentSlot.MAINHAND).isEmpty() && !list.isEmpty()) {
                this.soldier.getNavigation().moveTo((Entity)list.getFirst(), (double)1.2f);
                if (this.soldier.getNavigation().isDone()) {
                    this.pushToWardsItem(list.getFirst());
                }
            }
        } else {
            BlockPos pos = this.getPoiPos();
            if (pos != null) {
                this.setStatus((byte)2);
                if (pos.closerToCenterThan((Position)this.soldier.position(), 2.0)) {
                    this.soldier.getNavigation().stop();
                    if (this.getCapCache() != null && pos.equals((Object)this.getCapCache().pos())) {
                        IBlockStorageAccess cap = this.getCapCache().getCapability();
                        if (cap != null) {
                            this.soldier.setCarriedStack(cap.tryInserting(this.soldier.getCarriedStack()));
                        }
                        this.takeAShortBreak();
                    } else {
                        this.setCapCache();
                    }
                } else {
                    this.soldier.getNavigation().moveTo((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 1.2);
                }
            }
        }
    }

    public void start() {
        this.setCapCache();
        List<ItemEntity> list = this.getItemsInArea();
        if (!list.isEmpty()) {
            this.soldier.getNavigation().moveTo((Entity)list.getFirst(), (double)1.2f);
        }
    }

    private List<ItemEntity> getItemsInArea() {
        return PickUpItemsGoal.getItemsInArea(this.soldier, 8.0f, ALLOWED_ITEMS);
    }

    public static List<ItemEntity> getItemsInArea(AbstractClaySoldierEntity soldier, float verticalSearchRange, Predicate<ItemEntity> allowed) {
        return soldier.level().getEntitiesOfClass(ItemEntity.class, soldier.getBoundingBox().inflate(8.0, (double)verticalSearchRange, 8.0), allowed);
    }

    public static void pushToWardsItem(AbstractClaySoldierEntity soldier, ItemEntity itemEntity) {
        double zDif;
        double xDif = itemEntity.getX() - soldier.getX();
        double absMax = Mth.absMax((double)xDif, (double)(zDif = itemEntity.getZ() - soldier.getZ()));
        if (absMax >= (double)0.01f) {
            absMax = Math.sqrt(absMax);
            xDif /= absMax;
            zDif /= absMax;
            double invertedAbsMax = 1.0 / absMax;
            if (invertedAbsMax > 1.0) {
                invertedAbsMax = 1.0;
            }
            xDif *= invertedAbsMax;
            zDif *= invertedAbsMax;
            soldier.setDeltaMovement(soldier.getDeltaMovement().add(xDif *= (double)0.05f, 0.0, zDif *= (double)0.05f));
        }
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)PICK_UP_ITEM_LANG);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    @Override
    public boolean workRequiresItemPickUp() {
        return true;
    }

    @Override
    public boolean workRequiresItemCarrying() {
        return true;
    }
}

