/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal;

import java.util.function.Supplier;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.bumblebee.claysoldiers.entity.goal.workgoal.AbstractWorkGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class PlaceSeedsGoal
extends AbstractWorkGoal {
    public static final String PLACING_SEEDS_LANG = "clay_soldier_work.%s.job.%s".formatted("csr", "placing_seeds");
    private static final TagKey<Item> SEEDS = ItemTags.VILLAGER_PLANTABLE_SEEDS;
    @Nullable
    private BlockPos farmLandPos = null;
    private final int searchRange;
    private final int verticalSearchRange;
    protected int verticalSearchStart;
    protected int tryTicks;
    private int maxStayTicks;

    public PlaceSeedsGoal(AbstractClaySoldierEntity soldier, Supplier<WorkSelectorGoal> workSelector, int searchRange) {
        super(soldier, workSelector);
        this.searchRange = searchRange;
        this.verticalSearchRange = 2;
    }

    public boolean canUse() {
        if (this.isOnBreak()) {
            return false;
        }
        return this.getPoiPos() != null && this.getCapCacheResetIfInvalid() != null;
    }

    public boolean canContinueToUse() {
        if (this.isOnBreak()) {
            return false;
        }
        if (!this.soldier.getCarriedStack().isEmpty()) {
            return this.tryTicks >= -this.maxStayTicks && this.tryTicks <= 1200 && this.isValidTarget((LevelReader)this.soldier.level(), this.farmLandPos);
        }
        return super.canContinueToUse();
    }

    public void tick() {
        if (this.soldier.getCarriedStack().isEmpty()) {
            this.getSeedFromChest();
            this.setStatus((byte)2);
        } else {
            this.setStatus((byte)1);
            if (this.farmLandPos == null) {
                this.findNearestBlock();
                this.moveMobToBlock();
                this.tryTicks = 0;
                this.maxStayTicks = this.soldier.getRandom().nextInt(this.soldier.getRandom().nextInt(1200) + 1200) + 1200;
                return;
            }
            BlockPos blockpos = this.getMoveToTarget();
            if (!blockpos.closerToCenterThan((Position)this.soldier.position(), 2.0)) {
                ++this.tryTicks;
                if (this.shouldRecalculatePath()) {
                    this.soldier.getNavigation().moveTo((double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5, 1.0);
                }
            } else {
                this.plantSeed();
                --this.tryTicks;
            }
        }
    }

    private void getSeedFromChest() {
        if (this.moveToPoi() && this.getCapCacheResetIfInvalid() != null) {
            assert (this.getCapCache() != null);
            IBlockStorageAccess cap = this.getCapCache().getCapability();
            if (cap == null) {
                return;
            }
            this.soldier.setCarriedStack(cap.tryExtracting(stack -> stack.is(SEEDS), 1));
        }
        if (this.soldier.getCarriedStack().isEmpty()) {
            this.takeAShortBreak();
        }
    }

    private void plantSeed() {
        ItemStack seed = this.soldier.getCarriedStack();
        Level level = this.soldier.level();
        if (this.farmLandPos != null && this.isValidTarget((LevelReader)level, this.farmLandPos)) {
            Item item;
            BlockPos aboveFarmlandPos = this.farmLandPos.above();
            if (!seed.isEmpty() && seed.is(SEEDS) && (item = seed.getItem()) instanceof BlockItem) {
                BlockItem blockitem = (BlockItem)item;
                BlockState blockState = blockitem.getBlock().defaultBlockState();
                level.setBlockAndUpdate(aboveFarmlandPos, blockState);
                level.gameEvent((Holder)GameEvent.BLOCK_PLACE, aboveFarmlandPos, GameEvent.Context.of((Entity)this.soldier, (BlockState)blockState));
                this.soldier.setCarriedStack(ItemStack.EMPTY);
                this.farmLandPos = null;
            } else {
                this.soldier.dropItemStack(this.soldier.getCarriedStack().copy());
                this.soldier.setCarriedStack(ItemStack.EMPTY);
            }
        } else {
            this.findNearestBlock();
        }
    }

    protected boolean findNearestBlock() {
        BlockPos center = this.soldier.blockPosition();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int searchIndex = this.verticalSearchStart;
        while (searchIndex <= this.verticalSearchRange) {
            for (int rangeIndex = 0; rangeIndex < this.searchRange; ++rangeIndex) {
                int i1 = 0;
                while (i1 <= rangeIndex) {
                    int j1;
                    int n = j1 = i1 < rangeIndex && i1 > -rangeIndex ? rangeIndex : 0;
                    while (j1 <= rangeIndex) {
                        blockpos$mutableblockpos.setWithOffset((Vec3i)center, i1, searchIndex - 1, j1);
                        if (this.soldier.isWithinRestriction((BlockPos)blockpos$mutableblockpos) && this.isValidTarget((LevelReader)this.soldier.level(), (BlockPos)blockpos$mutableblockpos)) {
                            this.farmLandPos = blockpos$mutableblockpos;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            searchIndex = searchIndex > 0 ? -searchIndex : 1 - searchIndex;
        }
        this.takeAShortBreak();
        return false;
    }

    protected void moveMobToBlock() {
        if (this.farmLandPos == null) {
            return;
        }
        this.soldier.getNavigation().moveTo((double)this.farmLandPos.getX() + 0.5, (double)(this.farmLandPos.getY() + 1), (double)this.farmLandPos.getZ() + 0.5, 1.0);
    }

    protected boolean isValidTarget(LevelReader pLevel, @Nullable BlockPos pPos) {
        return pPos != null && pLevel.getBlockState(pPos).getBlock() instanceof FarmBlock && pLevel.getBlockState(pPos.above()).isAir();
    }

    protected BlockPos getMoveToTarget() {
        return this.farmLandPos.above();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 40 == 0;
    }

    @Override
    public boolean workRequiresItemCarrying() {
        return true;
    }

    @Override
    public Component getDisplayName() {
        return Component.translatable((String)PLACING_SEEDS_LANG);
    }
}

