/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierLike;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public final class AdditionalSoldierData {
    private static final String ERROR_MESSAGE_CASTING = "Wrong Entity Type for AdditionalSoldierData. %s does not extend ClayMobEntity and ClaySoldierLike";
    public static final Codec<AdditionalSoldierData> CODEC = RecordCodecBuilder.create(in -> in.group((App)AdditionalSoldierData.createEntityTypeCodec().fieldOf("type").forGetter(AdditionalSoldierData::soldierType), (App)CompoundTag.CODEC.optionalFieldOf("additional_data", (Object)new CompoundTag()).forGetter(AdditionalSoldierData::tag)).apply((Applicative)in, AdditionalSoldierData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AdditionalSoldierData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE), AdditionalSoldierData::soldierType, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, AdditionalSoldierData::tag, (type, tag) -> new AdditionalSoldierData((EntityType)AdditionalSoldierData.cast(type).getOrThrow(), (CompoundTag)tag));
    private final EntityType<? extends ClayMobEntity> soldierType;
    private final CompoundTag tag;

    public <T extends ClayMobEntity> AdditionalSoldierData(EntityType<T> soldierType, CompoundTag tag) {
        this.soldierType = soldierType;
        this.tag = tag;
    }

    public <T extends ClayMobEntity> void convert(T soldier, @Nullable Player cause) {
        ((ClaySoldierLike)((Object)soldier)).convertToSoldier(this.soldierType(), newSoldier -> {
            ((ClaySoldierLike)((Object)newSoldier)).readItemPersistentData(this.tag);
            newSoldier.setClayTeamType(soldier.getClayTeamType());
            ((ClaySoldierLike)((Object)newSoldier)).onConversion(soldier, this.tag, cause);
        });
    }

    public Component displayName() {
        return this.soldierType.getDescription();
    }

    public <T extends ClayMobEntity> EntityType<T> soldierType() {
        return this.soldierType;
    }

    public CompoundTag tag() {
        return this.tag;
    }

    private static <T extends ClayMobEntity> Codec<EntityType<T>> createEntityTypeCodec() {
        return BuiltInRegistries.ENTITY_TYPE.byNameCodec().comapFlatMap(AdditionalSoldierData::cast, entityType -> entityType);
    }

    private static <T extends ClayMobEntity> DataResult<EntityType<T>> cast(EntityType<?> type) {
        try {
            return DataResult.success(type);
        }
        catch (ClassCastException e) {
            return DataResult.error(() -> ERROR_MESSAGE_CASTING.formatted(type));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AdditionalSoldierData that = (AdditionalSoldierData)obj;
        return this.soldierType == that.soldierType && Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.soldierType, this.tag);
    }

    public String toString() {
        return "AdditionalSoldierData[Type: %s, Data: %s]".formatted(this.soldierType, this.tag);
    }
}

