/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier;

import java.util.UUID;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.VampireSubjugate;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.VampireClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModEffects;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ClaySoldierEntity
extends AbstractClaySoldierEntity
implements VampireSubjugate {
    @Nullable
    private UUID vampOwnerUUID;
    @Nullable
    private ClayMobEntity cachedVampOwner;

    public ClaySoldierEntity(EntityType<? extends AbstractClaySoldierEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel, AttackTypeProperty.NORMAL);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        this.addVampOwner(pCompound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.readVampOwner(pCompound);
    }

    @Override
    public void setVampOwner(@Nullable ClayMobEntity pOwner) {
        this.vampOwnerUUID = pOwner != null ? pOwner.getUUID() : null;
        this.cachedVampOwner = pOwner;
    }

    @Override
    @Nullable
    public ClayMobEntity getVampOwner() {
        Level level;
        if (!this.hasVampiricConversionEffect()) {
            return null;
        }
        if (this.cachedVampOwner != null && !this.cachedVampOwner.isRemoved()) {
            return this.cachedVampOwner;
        }
        if (this.vampOwnerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Entity entity = serverlevel.getEntity(this.vampOwnerUUID);
            if (entity instanceof ClayMobEntity) {
                ClayMobEntity clayMob;
                this.cachedVampOwner = clayMob = (ClayMobEntity)entity;
                return clayMob;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean hasVampiricConversionEffect() {
        return this.hasEffect(ModEffects.VAMPIRE_CONVERSION);
    }

    @Override
    public void applyConversionEffect(ClayMobEntity source) {
        if (!this.hasVampiricConversionEffect()) {
            this.addEffect(new MobEffectInstance(ModEffects.VAMPIRE_CONVERSION, 200, 4));
        }
        this.setVampOwner(source);
    }

    private void addVampOwner(CompoundTag compound) {
        if (this.vampOwnerUUID != null || this.hasVampiricConversionEffect()) {
            compound.putUUID("VampiricOnwer", this.vampOwnerUUID);
        }
    }

    private void readVampOwner(CompoundTag compound) {
        if (compound.hasUUID("VampiricOnwer")) {
            this.vampOwnerUUID = compound.getUUID("VampiricOnwer");
            this.cachedVampOwner = null;
        }
    }

    @Override
    public void convertToVampire() {
        VampireClaySoldierEntity vampire = (VampireClaySoldierEntity)ModEntityTypes.VAMPIRE_CLAY_SOLDIER_ENTITY.get().create(this.level(), EntitySpawnReason.CONVERSION);
        if (vampire != null) {
            vampire.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            vampire.setIsAlpha(false);
            this.copyBasePropertiesTo(vampire, false);
            if (this.getVampOwner() != null) {
                vampire.setClayTeamType(this.getVampOwner().getClayTeamType());
            } else {
                vampire.setClayTeamType(this.getClayTeamType());
            }
            this.level().addFreshEntity((Entity)vampire);
        }
    }
}

