/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier;

import java.util.function.BooleanSupplier;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class ClaySoldierMoveControl
extends MoveControl {
    private final BooleanSupplier canSwim;
    private final int maxTurnX;
    private final int maxTurnY;
    private final float inWaterSpeedModifier;
    private final float outsideWaterSpeedModifier;
    private final boolean applyGravity;

    public ClaySoldierMoveControl(AbstractClaySoldierEntity mob, BooleanSupplier canSwim, int maxTurnX, int maxTurnY, boolean applyGravity) {
        super((Mob)mob);
        this.canSwim = canSwim;
        this.maxTurnX = maxTurnX;
        this.maxTurnY = maxTurnY;
        this.inWaterSpeedModifier = 4.0f;
        this.outsideWaterSpeedModifier = 1.0f;
        this.applyGravity = applyGravity;
    }

    private boolean shouldUseSwimControl() {
        return this.mob.isInWater() && this.canSwim.getAsBoolean();
    }

    public void tick() {
        if (this.shouldUseSwimControl()) {
            this.waterTick();
        } else {
            super.tick();
        }
    }

    private void waterTick() {
        if (this.applyGravity && this.mob.isInWater()) {
            this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.005, 0.0));
        }
        if (this.operation == MoveControl.Operation.MOVE_TO && !this.mob.getNavigation().isDone()) {
            double difWantedZ;
            double difWantedY;
            double difWantedX = this.wantedX - this.mob.getX();
            double d3 = difWantedX * difWantedX + (difWantedY = this.wantedY - this.mob.getY()) * difWantedY + (difWantedZ = this.wantedZ - this.mob.getZ()) * difWantedZ;
            if (d3 < 2.500000277905201E-7) {
                this.mob.setZza(0.0f);
            } else {
                float f = (float)(Mth.atan2((double)difWantedZ, (double)difWantedX) * 180.0 / 3.1415927410125732) - 90.0f;
                this.mob.setYRot(this.rotlerp(this.mob.getYRot(), f, this.maxTurnY));
                this.mob.yBodyRot = this.mob.getYRot();
                this.mob.yHeadRot = this.mob.getYRot();
                float mobSpeed = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED));
                if (this.mob.isInWater()) {
                    this.mob.setSpeed(mobSpeed * this.inWaterSpeedModifier);
                    double flatDistance = Math.sqrt(difWantedX * difWantedX + difWantedZ * difWantedZ);
                    if (Math.abs(difWantedY) > (double)1.0E-5f || Math.abs(flatDistance) > (double)1.0E-5f) {
                        float f3 = -((float)(Mth.atan2((double)difWantedY, (double)flatDistance) * 180.0 / 3.1415927410125732));
                        f3 = Mth.clamp((float)Mth.wrapDegrees((float)f3), (float)(-this.maxTurnX), (float)this.maxTurnX);
                        this.mob.setXRot(this.rotlerp(this.mob.getXRot(), f3, 5.0f));
                    }
                    float f6 = Mth.cos((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
                    float f4 = Mth.sin((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
                    this.mob.zza = f6 * mobSpeed;
                    this.mob.yya = -f4 * mobSpeed;
                } else {
                    float f5 = Math.abs(Mth.wrapDegrees((float)(this.mob.getYRot() - f)));
                    float f2 = ClaySoldierMoveControl.getTurningSpeedFactor(f5);
                    this.mob.setSpeed(mobSpeed * this.outsideWaterSpeedModifier * f2);
                }
            }
        } else {
            this.mob.setSpeed(0.0f);
            this.mob.setXxa(0.0f);
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
        }
    }

    private static float getTurningSpeedFactor(float p_249853_) {
        return 1.0f - Mth.clamp((float)((p_249853_ - 10.0f) / 50.0f), (float)0.0f, (float)1.0f);
    }
}

