/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier;

import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class UndeadClaySoldier
extends AbstractClaySoldierEntity {
    protected UndeadClaySoldier(EntityType<? extends AbstractClaySoldierEntity> pEntityType, Level pLevel, AttackTypeProperty defaultAttackType) {
        super(pEntityType, pLevel, defaultAttackType);
        if (defaultAttackType.getStyle() == null) {
            throw new IllegalArgumentException("the default AttackType of Undead ClaySoldier cannot be %s because style is null".formatted(defaultAttackType));
        }
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(1, (Goal)new FleeSunGoal((PathfinderMob)this, this.getSunFleeSpeed()));
        super.registerGoals();
    }

    protected double getSunFleeSpeed() {
        return 1.0;
    }

    protected boolean isItemStackHelm(ItemStack stack) {
        SoldierHoldableEffect effect = new ItemStackWithEffect(stack).effect();
        return effect != null && effect.slots().contains(SoldierEquipmentSlot.HEAD);
    }

    @Override
    public void aiStep() {
        boolean sunBurnTick;
        boolean bl = sunBurnTick = this.isSunBurnTick() && this.getItemBySlot(SoldierEquipmentSlot.HEAD).isEmpty();
        if (sunBurnTick) {
            this.igniteForSeconds(6.0f);
        }
        super.aiStep();
    }

    @Override
    protected int decreaseAirSupply(int pCurrentAir) {
        return pCurrentAir;
    }

    @Override
    public boolean canSwim() {
        return false;
    }

    @Override
    public boolean canBeRevived() {
        return false;
    }

    @Override
    protected Component getInventoryName() {
        return Component.empty().append(this.getDisplayName()).withStyle(this.defaultAttackType.getAnimatedStyle((LivingEntity)this));
    }
}

