/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier;

import net.bumblebee.claysoldiers.entity.VampireSubjugate;
import net.bumblebee.claysoldiers.entity.VampiricClayMob;
import net.bumblebee.claysoldiers.entity.soldier.UndeadClaySoldier;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class VampireClaySoldierEntity
extends UndeadClaySoldier
implements VampiricClayMob {
    private static final EntityDataAccessor<Boolean> ALPHA = SynchedEntityData.defineId(VampireClaySoldierEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final String ALPHA_TAG = "Alpha";

    public VampireClaySoldierEntity(EntityType<? extends VampireClaySoldierEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel, AttackTypeProperty.VAMPIRE);
    }

    public void setIsAlpha(boolean subjugate) {
        this.entityData.set(ALPHA, (Object)subjugate);
    }

    public boolean isAlpha() {
        return (Boolean)this.entityData.get(ALPHA);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        if (this.isAlpha()) {
            pCompound.putBoolean(ALPHA_TAG, true);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains(ALPHA_TAG)) {
            this.setIsAlpha(true);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ALPHA, (Object)false);
    }

    @Override
    protected boolean specificTargetPredicate(LivingEntity target, ServerLevel level) {
        VampireSubjugate vampireSubjugate;
        if (target instanceof VampireSubjugate && (vampireSubjugate = (VampireSubjugate)target).isSubjugateOf(this)) {
            return false;
        }
        return super.specificTargetPredicate(target, level);
    }

    @Override
    protected double getSunFleeSpeed() {
        return 1.5;
    }

    @Override
    protected void specializedAttack(Entity target) {
        if (this.isAlpha()) {
            this.heal(this.getPowerMultiplier());
            if (target instanceof VampireSubjugate) {
                VampireSubjugate vampire = (VampireSubjugate)target;
                vampire.applyConversionEffect(this);
            }
        } else {
            this.heal(0.5f * this.getPowerMultiplier());
        }
    }

    @Override
    public void readItemPersistentData(CompoundTag tag) {
        if (tag.contains(ALPHA_TAG)) {
            this.setIsAlpha(tag.getBoolean(ALPHA_TAG));
        }
    }

    @Override
    public float getNightPower() {
        return (this.level().getMoonBrightness() + 1.0f) * 1.5f;
    }

    public float getSpeed() {
        return super.getSpeed() * this.getPowerMultiplier();
    }

    @Override
    public LevelAccessor getLevel() {
        return this.level();
    }
}

