/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.throwables;

import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClaySoldierThrowableItemEntity
extends ThrowableItemProjectile {
    @Nullable
    private ItemStackWithEffect thrownItem;

    public ClaySoldierThrowableItemEntity(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.thrownItem = null;
    }

    public ClaySoldierThrowableItemEntity(Level pLevel, LivingEntity shooter, @NotNull ItemStackWithEffect thrownItem) {
        super(ModEntityTypes.CLAY_SOLDIER_THROWABLE_ITEM.get(), shooter, pLevel, thrownItem.stack());
        this.thrownItem = thrownItem;
    }

    @NotNull
    protected Item getDefaultItem() {
        if (this.thrownItem == null) {
            if (this.getEntityData() == null) {
                return Items.STRUCTURE_VOID;
            }
            if (this.getItem().isEmpty()) {
                return Items.BARRIER;
            }
            return this.getItem().getItem();
        }
        return this.thrownItem.stack().getItem();
    }

    public void setItem(ItemStack stack) {
        super.setItem(stack);
        if (this.thrownItem == null || this.thrownItem.is(stack.getItem())) {
            this.thrownItem = new ItemStackWithEffect(stack);
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        Entity hitTarget = pResult.getEntity();
        if (this.thrownItem == null || this.thrownItem.effect() == null) {
            hitTarget.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
            this.discard();
            return;
        }
        SoldierHoldableEffect effect = this.thrownItem.effect();
        if (effect == null) {
            hitTarget.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
            this.discard();
            return;
        }
        float powerScale = pResult.getEntity() instanceof ClayMobEntity ? 0.2f : 1.0f;
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity thrower = (LivingEntity)entity;
            float bonusDamage = 0.0f;
            for (SpecialAttack<?> specialAttack : effect.getSpecialRangedAttacks()) {
                specialAttack.performAttackEffect(thrower, hitTarget);
                bonusDamage += specialAttack.getBonusDamage(thrower, hitTarget);
            }
            hitTarget.hurt(this.damageSources().thrown((Entity)this, (Entity)thrower), (effect.damage() + bonusDamage) * powerScale);
            int secOnFireInTicks = effect.properties().setOnFire();
            if (secOnFireInTicks > 0) {
                hitTarget.igniteForTicks(ClaySoldierThrowableItemEntity.adjustFireTicks(secOnFireInTicks, powerScale));
            }
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    private static int adjustFireTicks(int ticks, float power) {
        return Math.min(1, (int)((float)ticks * power));
    }

    private ParticleOptions getParticle() {
        ItemStack itemstack = this.getItem();
        return itemstack.isEmpty() ? ParticleTypes.ITEM_SNOWBALL : new ItemParticleOption(ParticleTypes.ITEM, itemstack);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ParticleOptions particleoptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particleoptions, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }
}

