/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.variant;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.entity.variant.NameableVariant;
import net.bumblebee.claysoldiers.item.claymobspawn.MultiSpawnItem;
import net.minecraft.resources.ResourceLocation;

public enum ClayHorseVariants implements NameableVariant
{
    CAKE(0, "cake", 15211805, ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/entity/clay_horse/cake.png")),
    GRASS(1, "grass", 8499282, ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/entity/clay_horse/grass.png")),
    SNOW(2, "snow", 14148065, ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/entity/clay_horse/snow.png")),
    MYCELIUM(3, "mycelium", 0x6F6262, ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"textures/entity/clay_horse/mycelium.png"));

    public static final EnumMap<ClayHorseVariants, Supplier<MultiSpawnItem<?>>> CLAY_HORSE_ITEM_BY_VARIANT;
    public static final EnumMap<ClayHorseVariants, Supplier<MultiSpawnItem<?>>> CLAY_PEGASUS_ITEM_BY_VARIANT;
    private final int id;
    private final String name;
    private final int pouchColor;
    private final ResourceLocation textureLocation;

    private ClayHorseVariants(int id, String name, int pouchColor, ResourceLocation textureLocation) {
        this.id = id;
        this.name = name;
        this.pouchColor = pouchColor;
        this.textureLocation = textureLocation;
    }

    @Override
    public int getPouchColor() {
        return this.pouchColor;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String getVariantName() {
        return this.name;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public static ClayHorseVariants getById(int id) {
        for (ClayHorseVariants clayHorseVariant : ClayHorseVariants.values()) {
            if (id != clayHorseVariant.id) continue;
            return clayHorseVariant;
        }
        return CAKE;
    }

    public static Supplier<MultiSpawnItem<?>> clayHorseByVariant(ClayHorseVariants variant) {
        return CLAY_HORSE_ITEM_BY_VARIANT.get(variant);
    }

    public static Supplier<MultiSpawnItem<?>> clayPegasusByVariant(ClayHorseVariants variant) {
        return CLAY_PEGASUS_ITEM_BY_VARIANT.get(variant);
    }

    static {
        CLAY_HORSE_ITEM_BY_VARIANT = Maps.newEnumMap(ClayHorseVariants.class);
        CLAY_PEGASUS_ITEM_BY_VARIANT = Maps.newEnumMap(ClayHorseVariants.class);
    }
}

