/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.init;

import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.blueprint.BlueprintManager;
import net.bumblebee.claysoldiers.init.ModEnchantments;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.item.blueprint.BlueprintDependendBlockItem;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class ModCreativeTab {
    public static final String CLAY_SOLDIERS_TAB_TITLE = "itemGroup.csr.clay_soldiers_tab";
    public static final String CLAY_SOLDIER_ITEMS_TAB_TITLE = "itemGroup.csr.clay_soldier_items_tab";
    public static final Supplier<CreativeModeTab> CLAY_SOLDIERS_TAB = ClaySoldiersCommon.PLATFORM.registerCreativeModeTab("clay_soldiers", builder -> builder.title((Component)Component.translatable((String)CLAY_SOLDIERS_TAB_TITLE)).icon(() -> ModItems.CLAY_SOLDIER.get().getDefaultInstance()).displayItems(ModCreativeTab.addAllItems()).build());
    public static final Supplier<CreativeModeTab> CLAY_SOLDIER_ITEMS_TAB = ClaySoldiersCommon.PLATFORM.registerCreativeModeTabSoldierItems();

    public static CreativeModeTab.DisplayItemsGenerator addAllItems() {
        return (itemDisplayParameters, output) -> {
            for (Item item : ClaySoldiersCommon.PLATFORM.getAllItems()) {
                if (item == ModItems.BLUEPRINT.get()) {
                    ModCreativeTab.modifyBlueprint(output, itemDisplayParameters.holders());
                } else {
                    output.accept((ItemLike)item);
                }
                if (!(item instanceof BlueprintDependendBlockItem) || !ClaySoldiersCommon.COMMON_HOOKS.isBlueprintEnabled(itemDisplayParameters.enabledFeatures())) continue;
                output.accept((ItemLike)item);
            }
            ModCreativeTab.modifySoldierItems(output, itemDisplayParameters.holders());
            output.accept(ModItems.createEnchantedBook(itemDisplayParameters.holders(), ModEnchantments.SOLDIER_PROJECTILE, 1));
        };
    }

    private static void modifySoldierItems(CreativeModeTab.Output out, HolderLookup.Provider registries) {
        ClaySoldiersCommon.LOGGER.debug("Adding {} Soldier Puppets in Creative Tab", (Object)(ClayMobTeamManger.getAllKeys(registries).count() - 1L));
        ClayMobTeamManger.getAllKeys(registries).forEach(key -> {
            if (!key.equals((Object)ClayMobTeamManger.DEFAULT_TYPE)) {
                ItemStack stack = ClayMobTeamManger.createStackForTeam(key, registries);
                out.accept(stack);
            }
        });
    }

    private static void modifyBlueprint(CreativeModeTab.Output out, HolderLookup.Provider holders) {
        for (ItemStack items : BlueprintManager.getBlueprintItems(holders)) {
            out.accept(items);
        }
    }

    public static void init() {
    }
}

