/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.soldieritemtypes.Generator;
import net.bumblebee.claysoldiers.soldieritemtypes.ItemGenerator;
import net.bumblebee.claysoldiers.soldieritemtypes.WeightedItem;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class ModItemGenerators {
    private static final NonNullList<ItemStack> EMPTY = NonNullList.withSize((int)0, (Object)ItemStack.EMPTY);
    private static final ItemGenerator DEFAULT_GENERATOR = new ItemGenerator(){

        @Override
        public ItemGenerator.Limit limitedBy() {
            return ItemGenerator.Limit.COUNT;
        }

        public String toString() {
            return "Default";
        }

        @Override
        public NonNullList<ItemStack> generateForTag(List<WeightedItem> available, int count, RandomSource random) {
            if (available.isEmpty()) {
                return NonNullList.create();
            }
            if (available.size() == 1) {
                NonNullList selectedItems = NonNullList.create();
                ModItemGenerators.addItemStackToList((List<ItemStack>)selectedItems, available.getFirst().getItem(), count);
                return selectedItems;
            }
            int i = 0;
            int pickedItems = 0;
            int size = available.size();
            HashMap<Item, Integer> amountMap = new HashMap<Item, Integer>(Math.min(count, size));
            while (pickedItems < count) {
                if (!ModItemGenerators.appendToMap(amountMap, available.get(i = (i + 1) % size), random)) continue;
                ++pickedItems;
            }
            NonNullList itemAmountAdjusted = NonNullList.createWithCapacity((int)amountMap.size());
            amountMap.forEach((item, amount) -> ModItemGenerators.addItemStackToList((List<ItemStack>)itemAmountAdjusted, item, amount));
            return itemAmountAdjusted;
        }
    };
    private static final ItemGenerator ONE_OF_EACH_GENERATOR = new ItemGenerator(){

        @Override
        public ItemGenerator.Limit limitedBy() {
            return ItemGenerator.Limit.SIZE;
        }

        @Override
        public NonNullList<ItemStack> generateForTag(List<WeightedItem> available, int count, RandomSource random) {
            int availableSize = available.size();
            int adjustedCount = Math.min(availableSize, count);
            NonNullList selected = NonNullList.createWithCapacity((int)adjustedCount);
            int randomOffset = random.nextInt(availableSize);
            for (int i = 0; i < adjustedCount; ++i) {
                selected.add((Object)available.get((i + randomOffset) % availableSize).asStack());
            }
            return selected;
        }

        public String toString() {
            return "One of Each";
        }
    };
    public static final Supplier<ItemGenerator> DEFAULT = ClaySoldiersCommon.PLATFORM.registerItemGenerator("default", () -> DEFAULT_GENERATOR);
    public static final Supplier<ItemGenerator> ONE_OF_EACH = ClaySoldiersCommon.PLATFORM.registerItemGenerator("one_of_each", () -> ONE_OF_EACH_GENERATOR);
    public static final Supplier<ItemGenerator> ONE_OF_EACH_NO_TAG = ClaySoldiersCommon.PLATFORM.registerItemGenerator("one_of_each_no_tag", () -> ModItemGenerators.createdNoTagGenerator(ONE_OF_EACH_GENERATOR));
    public static final Supplier<ItemGenerator> COMBINED_DEFAULTED = ClaySoldiersCommon.PLATFORM.registerItemGenerator("combined_defaulted", () -> ModItemGenerators.createdCombinedGenerator(DEFAULT_GENERATOR));

    public static void init() {
    }

    private static ItemGenerator createdCombinedGenerator(final ItemGenerator base) {
        return new ItemGenerator(){

            @Override
            public NonNullList<ItemStack> generate(List<WeightedItem> ignored, int count, RandomSource random, List<Generator> all) {
                NonNullList selected = NonNullList.create();
                ArrayList<Generator> generatedExpected = new ArrayList<Generator>(all);
                int initialIndividualCount = count / generatedExpected.size();
                int remaining = count % generatedExpected.size();
                Iterator it = generatedExpected.iterator();
                while (it.hasNext()) {
                    Generator generator = (Generator)it.next();
                    NonNullList<ItemStack> generated = generator.generateForTag(initialIndividualCount, random);
                    selected.addAll(generated);
                    if (generator.limitedBy() != ItemGenerator.Limit.SIZE) continue;
                    remaining += initialIndividualCount - generated.size();
                    it.remove();
                }
                initialIndividualCount = remaining / generatedExpected.size();
                remaining %= generatedExpected.size();
                for (int i = 0; i < generatedExpected.size(); ++i) {
                    selected.addAll(((Generator)generatedExpected.get(i)).generateForTag(initialIndividualCount + (remaining < i ? 1 : 0), random));
                }
                return selected;
            }

            @Override
            public ItemGenerator.Limit limitedBy() {
                return base.limitedBy();
            }

            @Override
            public NonNullList<ItemStack> generateForTag(List<WeightedItem> available, int count, RandomSource random) {
                return base.generateForTag(available, count, random);
            }

            public String toString() {
                return "Combined(%s)".formatted(base);
            }
        };
    }

    private static ItemGenerator createdNoTagGenerator(final ItemGenerator base) {
        return new ItemGenerator(){

            @Override
            public ItemGenerator.Limit limitedBy() {
                return ItemGenerator.Limit.ZERO;
            }

            @Override
            public NonNullList<ItemStack> generateForTag(List<WeightedItem> available, int count, RandomSource random) {
                return EMPTY;
            }

            @Override
            public NonNullList<ItemStack> generate(List<WeightedItem> available, int count, RandomSource random, List<Generator> all) {
                return base.generate(available, count, random, all);
            }

            public String toString() {
                return base.toString() + "(No Tag)";
            }
        };
    }

    private static boolean appendToMap(Map<Item, Integer> items, WeightedItem weightItem, RandomSource random) {
        if (random.nextFloat() < weightItem.getWeight()) {
            Integer count = items.get(weightItem.getItem());
            if (count == null) {
                items.put(weightItem.getItem(), 1);
            } else {
                count = count + 1;
                items.put(weightItem.getItem(), count);
            }
            return true;
        }
        return false;
    }

    private static void addItemStackToList(List<ItemStack> itemsCounted, Item item, int count) {
        int maxStackSize = item.getDefaultMaxStackSize();
        if (count <= maxStackSize) {
            itemsCounted.add(new ItemStack((ItemLike)item, count));
        } else {
            itemsCounted.add(new ItemStack((ItemLike)item, maxStackSize));
            ModItemGenerators.addItemStackToList(itemsCounted, item, count - maxStackSize);
        }
    }
}

