/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration;

import java.util.HashMap;
import net.bumblebee.claysoldiers.capability.AssignableWorksiteCapability;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class CreateHandCrankWorksite
implements AssignableWorksiteCapability {
    public static final ResourceLocation WORKSITE_ID = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"hand_crank");
    private static int handIndex = 0;
    private final HashMap<ClayMobEntity, TimeUsedData> timesUse = new HashMap();

    @Override
    public boolean canUse(ClayMobEntity clayMob) {
        return true;
    }

    @Override
    public int onUse(ClayMobEntity clayMob) {
        ++handIndex;
        long gameTime = clayMob.level().getGameTime();
        this.timesUse.compute(clayMob, (k, v) -> v == null ? new TimeUsedData(1, gameTime) : v.update(gameTime));
        this.timesUse.entrySet().removeIf(e -> !((TimeUsedData)e.getValue()).isStillValid(gameTime));
        if (handIndex % 3 == 0 || handIndex % 7 == 0) {
            clayMob.swing(InteractionHand.MAIN_HAND);
        } else {
            clayMob.swing(InteractionHand.OFF_HAND);
        }
        return 1;
    }

    @Override
    public boolean isOneTimeUse() {
        return false;
    }

    @Override
    public ResourceLocation descriptionId() {
        return WORKSITE_ID;
    }

    public static void register(RegisterCapabilitiesEvent event) {
    }

    private static final class TimeUsedData {
        private int used;
        private long lastUsed;

        private TimeUsedData(int used, long dameTime) {
            this.used = used;
            this.lastUsed = dameTime;
        }

        public TimeUsedData update(long gameTime) {
            ++this.used;
            this.lastUsed = gameTime;
            return this;
        }

        public boolean isStillValid(long gameTime) {
            return this.lastUsed + 20L >= gameTime;
        }

        public int getUsed() {
            return this.used;
        }
    }
}

