/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;

public class NeoForgeAirBubbleElement
extends Element {
    public static final ResourceLocation AIR_BUBBLE = ResourceLocation.withDefaultNamespace((String)"hud/air");
    public static final ResourceLocation AIR_BUBBLE_BURSTING = ResourceLocation.withDefaultNamespace((String)"hud/air_bursting");
    private final int armor;
    private final boolean bursting;
    private final int iconsPerLine;
    private final int lineCount = 1;
    private final int iconCount;

    public NeoForgeAirBubbleElement(int breath, boolean bursting) {
        this.bursting = bursting;
        if (breath > 10 || breath < 0) {
            throw new IllegalArgumentException("Breath needs to be in range [0;10]");
        }
        this.armor = breath;
        this.iconCount = breath;
        this.iconsPerLine = Math.min(10, this.iconCount);
    }

    public Vec2 getSize() {
        return new Vec2((float)(8 * this.iconsPerLine + 1), 9.0f);
    }

    public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
        if (this.iconCount == 0) {
            return;
        }
        IDisplayHelper helper = IDisplayHelper.get();
        int xOffset = (this.iconCount - 1) % this.iconsPerLine * 8;
        int yOffset = 0;
        for (int i = this.iconCount; i > 0; --i) {
            if (this.bursting && i == this.iconCount) {
                helper.blitSprite(guiGraphics, RenderType.GUI_TEXTURED, AIR_BUBBLE_BURSTING, (int)(x + (float)xOffset), (int)(y + (float)yOffset), 9, 9);
            } else if (i <= Mth.floor((float)this.armor)) {
                helper.blitSprite(guiGraphics, RenderType.GUI_TEXTURED, AIR_BUBBLE, (int)(x + (float)xOffset), (int)(y + (float)yOffset), 9, 9);
            }
            if ((xOffset -= 8) >= 0) continue;
            xOffset = this.iconsPerLine * 8 - 8;
            yOffset -= 4;
        }
    }
}

