/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.accessories;

import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.AccessoryRegistry;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.item.claymobspawn.ClaySoldierSpawnItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ModAccessories {
    public static void init() {
        for (Accessories accessory : Accessories.values()) {
            AccessoryRegistry.register((Item)accessory.item.get(), (Accessory)accessory);
        }
        ClaySoldiersCommon.IS_WEARING_GOGGLES = ClaySoldiersCommon.IS_WEARING_GOGGLES.or(p -> ModAccessories.hasAccessory((Entity)p, stack -> stack.is((Item)ModItems.CLAY_GOGGLES.get())));
        ClaySoldiersCommon.IS_WEARING_CLAY_SOLDIER.add(e -> ModAccessories.hasAccessory((Entity)e, stack -> stack.is((Item)ModItems.CLAY_SOLDIER.get())));
    }

    public static boolean hasAccessory(Entity pEntity, Predicate<ItemStack> condition) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pEntity;
            return AccessoriesCapability.getOptionally((LivingEntity)livingEntity).map(c -> c.getFirstEquipped(condition)).isPresent();
        }
        return false;
    }

    private static enum Accessories implements Accessory
    {
        CLAY_GOGGLES(ModItems.CLAY_GOGGLES),
        CLAY_SOLDIER(ModItems.CLAY_SOLDIER){

            public boolean canEquip(ItemStack stack, SlotReference reference) {
                LivingEntity livingEntity = reference.entity();
                if (!(livingEntity instanceof Player)) {
                    return false;
                }
                Player player = (Player)livingEntity;
                ResourceLocation team = (ResourceLocation)stack.get(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get());
                return team != null && ClaySoldierSpawnItem.canEquipClaySoldier(player, team);
            }

            public int maxStackSize(ItemStack stack) {
                return 1;
            }

            public void onEquip(ItemStack stack, SlotReference reference) {
                LivingEntity livingEntity = reference.entity();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    ModCriterions.CLAY_SOLDIER_ON_HEAD_TRIGGER.get().trigger(serverPlayer);
                }
            }
        };

        private final Supplier<? extends Item> item;

        private Accessories(Supplier<? extends Item> item) {
            this.item = item;
        }
    }
}

