/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.curios;

import java.util.List;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.item.claymobspawn.ClaySoldierSpawnItem;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class ModCurios {
    public ModCurios(IEventBus modEventBus) {
        modEventBus.addListener(this::registerCapabilities);
        modEventBus.addListener(this::commonSetup);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ClaySoldiersCommon.IS_WEARING_GOGGLES = ClaySoldiersCommon.IS_WEARING_GOGGLES.or(p -> ModCurios.hasItem(p, (Item)ModItems.CLAY_GOGGLES.get()));
        ClaySoldiersCommon.IS_WEARING_CLAY_SOLDIER.add(p -> ModCurios.hasItem(p, ModItems.CLAY_SOLDIER.get()));
    }

    private static boolean hasItem(Player player, Item item) {
        ICuriosItemHandler cap = (ICuriosItemHandler)player.getCapability(CuriosCapability.INVENTORY);
        if (cap == null) {
            return false;
        }
        for (ICurioStacksHandler stacksHandler : cap.getCurios().values()) {
            int slots = stacksHandler.getSlots();
            for (int slot = 0; slot < slots; ++slot) {
                if (!stacksHandler.getStacks().getStackInSlot(slot).is(item)) continue;
                return true;
            }
        }
        return false;
    }

    private void registerCapabilities(RegisterCapabilitiesEvent evt) {
        evt.registerItem(CuriosCapability.ITEM, (stack, context) -> SoldierCurios.create(stack), new ItemLike[]{ModItems.CLAY_SOLDIER});
    }

    private record SoldierCurios(ItemStack stack, ResourceLocation team) implements ICurio
    {
        @Nullable
        public static SoldierCurios create(ItemStack stack) {
            ResourceLocation team = ClaySoldierSpawnItem.getTeamFromStack(stack);
            if (team == null) {
                return null;
            }
            return new SoldierCurios(stack, team);
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public List<Component> getSlotsTooltip(List<Component> tooltips, Item.TooltipContext context) {
            return List.of();
        }

        public boolean canEquip(SlotContext slotContext) {
            LivingEntity livingEntity = slotContext.entity();
            if (!(livingEntity instanceof Player)) {
                return false;
            }
            Player player = (Player)livingEntity;
            return ClaySoldierSpawnItem.canEquipClaySoldier(player, this.team);
        }

        public void onEquip(SlotContext slotContext, ItemStack prevStack) {
            LivingEntity livingEntity = slotContext.entity();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                ModCriterions.CLAY_SOLDIER_ON_HEAD_TRIGGER.get().trigger(serverPlayer);
            }
        }
    }
}

