/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.curios;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.item.claymobspawn.ClaySoldierOnHeadModel;
import net.bumblebee.claysoldiers.item.claymobspawn.ClaySoldierSpawnItem;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosSlotTypes;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public final class ModCuriosRenderers {
    public ModCuriosRenderers(IEventBus modEventBus) {
        modEventBus.addListener(this::addLayerEvent);
        modEventBus.addListener(this::init);
        NeoForge.EVENT_BUS.addListener(this::tooltipEvent);
    }

    public void addLayerEvent(EntityRenderersEvent.AddLayers event) {
        CuriosHeadLayer.equipmentRenderer = event.getContext().getEquipmentRenderer();
    }

    public void init(FMLClientSetupEvent event) {
        ICurioRenderer.register((Item)((Item)ModItems.CLAY_GOGGLES.get()), CuriosHeadLayer::clayGoggles);
        ICurioRenderer.register((Item)ModItems.CLAY_SOLDIER.get(), SoldierOnHeadLayer::claySoldier);
    }

    public void tooltipEvent(ItemTooltipEvent event) {
        Component component;
        Player player = event.getEntity();
        if (!event.getItemStack().is((Item)ModItems.CLAY_SOLDIER.get()) || player == null) {
            return;
        }
        ResourceLocation team = (ResourceLocation)event.getItemStack().get(ModDataComponents.CLAY_MOB_TEAM_COMPONENT);
        if (team == null) {
            return;
        }
        if (ClaySoldierSpawnItem.canEquipClaySoldier(player, team) && (component = ModCuriosRenderers.appendDefaultSlotTooltip(event.getItemStack(), player)) != null) {
            event.getToolTip().add(component);
            event.getToolTip().add(CommonComponents.space().append((Component)Component.translatable((String)ClaySoldierSpawnItem.DESCRIPTION_LANG).withStyle(ChatFormatting.GRAY)));
        }
    }

    private static Component appendDefaultSlotTooltip(ItemStack stack, Player player) {
        if (stack.isEmpty()) {
            return null;
        }
        Map slots = CuriosSlotTypes.getItemSlotTypes((ItemStack)stack, (LivingEntity)player);
        slots.remove("curio");
        if (slots.isEmpty()) {
            return null;
        }
        List slotIds = slots.keySet().stream().toList();
        MutableComponent slotsTooltip = Component.translatable((String)"curios.tooltip.slot").append(" ").withStyle(ChatFormatting.GOLD);
        for (int j = 0; j < slotIds.size(); ++j) {
            String id = (String)slotIds.get(j);
            String key = "curios.identifier." + id;
            MutableComponent type = Component.translatableWithFallback((String)key, (String)(Character.toUpperCase(id.charAt(0)) + id.substring(1).toLowerCase()));
            if (j < slotIds.size() - 1) {
                type = type.append(", ");
            }
            type = type.withStyle(ChatFormatting.YELLOW);
            slotsTooltip.append((Component)type);
        }
        return slotsTooltip;
    }

    private static class CuriosHeadLayer
    implements ICurioRenderer {
        private final HumanoidModel<? extends HumanoidRenderState> model;
        private static EquipmentLayerRenderer equipmentRenderer;

        public CuriosHeadLayer(HumanoidModel<? extends HumanoidRenderState> part) {
            this.model = part;
        }

        private static CuriosHeadLayer clayGoggles() {
            return new CuriosHeadLayer((HumanoidModel<? extends HumanoidRenderState>)new HumanoidArmorModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)));
        }

        public <S extends LivingEntityRenderState, M extends EntityModel<? super S>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, @NotNull MultiBufferSource renderTypeBuffer, int packedLight, S renderState, RenderLayerParent<S, M> renderLayerParent, EntityRendererProvider.Context context, float yRotation, float xRotation) {
            Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
            if (equippable == null || equipmentRenderer == null) {
                return;
            }
            ICurioRenderer.setupHumanoidAnimations(this.model, renderState);
            equipmentRenderer.renderLayers(EquipmentClientInfo.LayerType.HUMANOID, (ResourceKey)equippable.assetId().orElseThrow(), this.model, stack, poseStack, renderTypeBuffer, packedLight);
        }
    }

    private record SoldierOnHeadLayer(ClaySoldierOnHeadModel<?> model) implements ICurioRenderer
    {
        private static SoldierOnHeadLayer claySoldier() {
            return new SoldierOnHeadLayer(ClaySoldierOnHeadModel.createModel());
        }

        public <S extends LivingEntityRenderState, M extends EntityModel<? super S>> void render(ItemStack stack, SlotContext slotContext, PoseStack poseStack, @NotNull MultiBufferSource renderTypeBuffer, int packedLight, S renderState, RenderLayerParent<S, M> renderLayerParent, EntityRendererProvider.Context context, float yRotation, float xRotation) {
            ResourceLocation team = (ResourceLocation)stack.get(ModDataComponents.CLAY_MOB_TEAM_COMPONENT);
            if (team == null) {
                return;
            }
            ClayMobTeamManger.getOptional(team, (HolderLookup.Provider)slotContext.entity().registryAccess()).ifPresent(t -> {
                EntityModel patt0$temp = renderLayerParent.getModel();
                if (patt0$temp instanceof HumanoidModel) {
                    HumanoidModel humanoidModel = (HumanoidModel)patt0$temp;
                    this.model.copyHeadRotation(humanoidModel);
                }
                this.model.setupAnimSoldierAnim(renderState);
                this.model.render(poseStack, renderTypeBuffer, packedLight, t.getColor(0, renderState.ageInTicks));
            });
        }
    }
}

