/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jade;

import java.util.ArrayList;
import java.util.List;
import net.bumblebee.claysoldiers.integration.jade.CommonBlockProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonEntityProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonEntityServerAppender;
import net.bumblebee.claysoldiers.integration.jade.providers.BossClaySoldierProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.ClayMobProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.ClaySoldierProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.ClayWraithProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.EaselBlockProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.HamsterWheelBlockProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.VampireClaySoldierProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.ZombieClaySoldierProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class JadeRegistry {
    private static final List<CommonBlockProvider> JADE_BLOCKS = new ArrayList<CommonBlockProvider>();
    private static final List<CommonEntityProvider<?>> JADE_ENTITY = new ArrayList();
    private static final List<CommonEntityServerAppender<?>> JADE_ENTITY_SERVER = new ArrayList();
    public static final String BASE_LANG = "jade.plugin.csr.%s.%s";
    public static final ResourceLocation CLAY_MOB = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_mob");
    public static final ResourceLocation CLAY_SOLDIER = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier");
    public static final ResourceLocation ZOMBIE_CLAY_SOLDIER = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"zombie_clay_soldier");
    public static final ResourceLocation CLAY_WRAITH = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_wraith");
    public static final ResourceLocation VAMPIRE_SOLDIER = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"vampire_clay_soldier");
    public static final ResourceLocation EASEL_BLOCK = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"easel_block_storage");
    public static final ResourceLocation HAMSTER_WHEEL_BLOCK = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"hamster_wheel");
    public static final ResourceLocation BOSS_CLAY_SOLDIER = ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"boss_clay_soldier");

    public static String getLangKey(CommonBlockProvider provider, String suffix) {
        return BASE_LANG.formatted(provider.getUniqueId().getPath(), suffix);
    }

    public static String getLangKey(CommonEntityProvider<?> provider, String suffix) {
        return BASE_LANG.formatted(provider.getUniqueId().getPath(), suffix);
    }

    public static void registerBlockProvider(CommonBlockProvider blockProvider) {
        JADE_BLOCKS.add(blockProvider);
    }

    public static <T extends Entity> void registerEntityProvider(CommonEntityProvider<T> entityProvider) {
        JADE_ENTITY.add(entityProvider);
    }

    public static <T extends Entity> void registerEntityServerAppender(CommonEntityServerAppender<T> serverAppender) {
        JADE_ENTITY_SERVER.add(serverAppender);
    }

    public static List<CommonBlockProvider> getBlocks() {
        return JADE_BLOCKS;
    }

    public static List<CommonEntityProvider<?>> getEntities() {
        return JADE_ENTITY;
    }

    public static List<CommonEntityServerAppender<?>> getServerEntities() {
        return JADE_ENTITY_SERVER;
    }

    static {
        JadeRegistry.registerEntityProvider(ClayMobProvider.INSTANCE);
        JadeRegistry.registerEntityProvider(ClaySoldierProvider.INSTANCE);
        JadeRegistry.registerEntityProvider(VampireClaySoldierProvider.INSTANCE);
        JadeRegistry.registerEntityProvider(ZombieClaySoldierProvider.INSTANCE);
        JadeRegistry.registerEntityProvider(ClayWraithProvider.INSTANCE);
        JadeRegistry.registerEntityProvider(BossClaySoldierProvider.INSTANCE);
        JadeRegistry.registerEntityServerAppender(ClayWraithProvider.INSTANCE);
        JadeRegistry.registerEntityServerAppender(ZombieClaySoldierProvider.INSTANCE);
        JadeRegistry.registerBlockProvider(EaselBlockProvider.INSTANCE);
        JadeRegistry.registerBlockProvider(HamsterWheelBlockProvider.INSTANCE);
    }
}

