/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jei;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ClaySoldierCrafting {
    private static final String CLAY_SOLDIER_REVIVING = "jei.csr.soldier.revive";
    private static final String CLAY_SOLDIER_CRAFTING = "jei.csr.soldier.crafting";

    public static List<RecipeHolder<CraftingRecipe>> createRecipes() {
        Stream<ResourceLocation> allKeys = ClayMobTeamManger.getAllKeys((HolderLookup.Provider)ClaySoldierCrafting.getRegistries());
        return allKeys.mapMulti((entry, r) -> {
            for (int i = 1; i <= 8; ++i) {
                r.accept(ClaySoldierCrafting.createRecipe(entry, i));
            }
        }).filter(Objects::nonNull).toList();
    }

    @Nullable
    private static RecipeHolder<CraftingRecipe> createRecipe(ResourceLocation entry, int count) {
        Item getFrom = ClayMobTeamManger.getFromKeyOrError(entry, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).getGetFrom();
        if (getFrom == null) {
            return null;
        }
        NonNullList inputs = NonNullList.createWithCapacity((int)(count + 1));
        inputs.add((Object)Ingredient.of((ItemLike)getFrom));
        for (int i = 0; i < count; ++i) {
            inputs.add((Object)Ingredient.of((ItemLike)ModItems.CLAY_SOLDIER.get()));
        }
        ItemStack output = ClayMobTeamManger.createStackForTeam(entry, (HolderLookup.Provider)ClaySoldierCrafting.getRegistries());
        output.setCount(count);
        ResourceKey recipeId = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"csr", (String)("jei.csr.soldier.crafting." + entry.getPath().toString() + "_" + count)));
        ShapelessRecipe recipe = new ShapelessRecipe(CLAY_SOLDIER_CRAFTING, CraftingBookCategory.MISC, output, (List)inputs);
        return new RecipeHolder(recipeId, (Recipe)recipe);
    }

    public static List<RecipeHolder<CraftingRecipe>> createClaySoldierRevive() {
        return ClayMobTeamManger.getAllKeys((HolderLookup.Provider)ClaySoldierCrafting.getRegistries()).map(ClaySoldierCrafting::createClaySoldierRevive).toList();
    }

    public static RecipeHolder<CraftingRecipe> createClaySoldierRevive(ResourceLocation team) {
        ItemStack output = ClayMobTeamManger.createStackForTeam(team, (HolderLookup.Provider)ClaySoldierCrafting.getRegistries());
        ItemStack input = ModItems.BRICKED_CLAY_SOLDIER.get().getDefaultInstance();
        input.set(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get(), (Object)team);
        ResourceKey recipeId = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"csr", (String)("jei.csr.soldier.revive." + team.getPath())));
        List<Ingredient> inputs = List.of(Ingredient.of((ItemLike)((ItemLike)ModItems.BRICKED_CLAY_SOLDIER.get())), Ingredient.of((ItemLike)Items.GHAST_TEAR));
        ShapelessRecipe recipe = new ShapelessRecipe(CLAY_SOLDIER_REVIVING, CraftingBookCategory.MISC, output, inputs);
        return new RecipeHolder(recipeId, (Recipe)recipe);
    }

    private static RegistryAccess getRegistries() {
        return Minecraft.getInstance().level.registryAccess();
    }
}

