/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.integration.jei.ClaySoldierCookingRecipe;
import net.bumblebee.claysoldiers.integration.jei.ClaySoldierCrafting;
import net.bumblebee.claysoldiers.util.ComponentFormating;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, ClaySoldierCrafting.createRecipes());
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, ClaySoldierCrafting.createClaySoldierRevive());
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, JEIPlugin.createShearBladeRecipe());
        registration.addRecipes((IRecipeType)RecipeTypes.SMELTING, ClaySoldierCookingRecipe.createCookingRecipe(SmeltingRecipe::new, 100));
        registration.addRecipes((IRecipeType)RecipeTypes.BLASTING, ClaySoldierCookingRecipe.createCookingRecipe(BlastingRecipe::new, 50));
        registration.addRecipes((IRecipeType)RecipeTypes.CAMPFIRE_COOKING, ClaySoldierCookingRecipe.createCookingRecipe(CampfireCookingRecipe::new, 200));
        registration.addRecipes((IRecipeType)RecipeTypes.SMOKING, ClaySoldierCookingRecipe.createCookingRecipe(SmokingRecipe::new, 300));
        BuiltInRegistries.ITEM.get(ModTags.Items.SOLDIER_HOLDABLE).ifPresentOrElse(set -> JEIPlugin.addItemToInfo(registration, set.stream().map(Holder::value), ClaySoldiersCommon.DATA_MAP::getEffect, ComponentFormating::addHoldableTooltip), () -> ClaySoldiersCommon.LOGGER.error("Could not load JEI Info for Clay Soldier Holdable Items"));
        BuiltInRegistries.ITEM.get(ModTags.Items.SOLDIER_POI).ifPresentOrElse(set -> {
            JEIPlugin.addItemToInfo(registration, set.stream().map(Holder::value), ClaySoldiersCommon.DATA_MAP::getItemPoi, (poi, list) -> {
                list.add(Component.translatable((String)"item.tooltip.csr.soldier_poi_item").withStyle(ChatFormatting.DARK_GRAY));
                ComponentFormating.addPoiTooltip(poi, list);
            });
            JEIPlugin.addItemToInfo(registration, set.stream().map(Holder::value), ClaySoldiersCommon.DATA_MAP::getBlockPoi, (poi, list) -> {
                list.add(Component.translatable((String)"item.tooltip.csr.soldier_poi_block").withStyle(ChatFormatting.DARK_GRAY));
                ComponentFormating.addPoiTooltip(poi, list);
            });
        }, () -> ClaySoldiersCommon.LOGGER.error("Could not load JEI Info for Clay Soldier POIs "));
    }

    private static <T> void addItemToInfo(IRecipeRegistration registration, Stream<Item> items, Function<Item, T> effectGetter, BiConsumer<T, List<Component>> getDescription) {
        items.forEach(item -> {
            Object effect = effectGetter.apply((Item)item);
            if (effect != null) {
                ArrayList tooltip = new ArrayList();
                getDescription.accept(effect, tooltip);
                registration.addIngredientInfo((ItemLike)item, (Component[])tooltip.toArray(Component[]::new));
            }
        });
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.CLAY_SOLDIER.get(), (ISubtypeInterpreter)ClaySoldierPuppetInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModItems.BLUEPRINT.get(), (ISubtypeInterpreter)BlueprintInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter((Item)ModItems.BRICKED_CLAY_SOLDIER.get(), (ISubtypeInterpreter)ClaySoldierPuppetInterpreter.INSTANCE);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"jei_plugin");
    }

    public static List<RecipeHolder<CraftingRecipe>> createShearBladeRecipe() {
        return List.of(new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"jei.shear_blade")), (Recipe)new ShapelessRecipe("%s.shear_blade".formatted("csr"), CraftingBookCategory.EQUIPMENT, ModItems.SHEAR_BLADE.get().getDefaultInstance(), List.of(Ingredient.of((ItemLike)Items.SHEARS)))));
    }

    private static enum ClaySoldierPuppetInterpreter implements ISubtypeInterpreter<ItemStack>
    {
        INSTANCE;


        @Nullable
        public Object getSubtypeData(ItemStack ingredient, UidContext context) {
            return ingredient.get(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get());
        }
    }

    private static enum BlueprintInterpreter implements ISubtypeInterpreter<ItemStack>
    {
        INSTANCE;


        @Nullable
        public Object getSubtypeData(ItemStack ingredient, UidContext context) {
            return ingredient.get(ModDataComponents.BLUEPRINT_DATA.get());
        }
    }
}

