/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.function.IntFunction;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ClayBrushItem
extends Item {
    public static final String POI_SET_LANG = "item.csr.clay_brush.poi.set";
    public static final String POI_CLEAR_LANG = "item.csr.clay_brush.poi.clear";
    public static final String NO_MODE_LANG = "item.csr.clay_brush.mode.no_mode";

    public ClayBrushItem(Item.Properties pProperties) {
        super(pProperties.component(ModDataComponents.CLAY_BRUSH_MODE.get(), (Object)Mode.COMMAND).component(ModDataComponents.CLAY_BRUSH_POI.get(), (Object)PoiPos.EMPTY));
    }

    public boolean canAttackBlock(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        ItemStack itemInHand;
        if (!pLevel.isClientSide && ClayBrushItem.getMode(itemInHand = pPlayer.getItemInHand(InteractionHand.MAIN_HAND)) == Mode.POI && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            if (pPlayer.isCrouching()) {
                ClayBrushItem.message(serverPlayer, (Component)Component.translatable((String)POI_CLEAR_LANG).withColor(Mode.POI.color));
                ClayBrushItem.setPoiPos(itemInHand, null);
            } else {
                ClayBrushItem.message(serverPlayer, (Component)Component.translatable((String)POI_SET_LANG, (Object[])new Object[]{pPos.toShortString()}).withColor(Mode.POI.color));
                ClayBrushItem.setPoiPos(itemInHand, pPos);
            }
        }
        return false;
    }

    private static void setPoiPos(ItemStack stack, @Nullable BlockPos pos) {
        stack.set(ModDataComponents.CLAY_BRUSH_POI.get(), (Object)(pos == null ? PoiPos.EMPTY : new PoiPos(pos, false)));
    }

    private void cycleMode(ItemStack itemInHand, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Mode mode = (Mode)itemInHand.get(ModDataComponents.CLAY_BRUSH_MODE.get());
            int n = 0;
            Mode newMode = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"COMMAND", "WORK", "POI"}, (Mode)mode, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> Mode.WORK;
                case 1 -> Mode.POI;
                case 2 -> Mode.COMMAND;
                case -1 -> Mode.COMMAND;
            };
            itemInHand.set(ModDataComponents.CLAY_BRUSH_MODE.get(), (Object)newMode);
            ClayBrushItem.message(serverPlayer, newMode.getDisplayName());
        }
    }

    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack itemInHand = pContext.getItemInHand();
        this.cycleMode(itemInHand, pContext.getPlayer());
        return InteractionResult.SUCCESS;
    }

    public InteractionResult use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        this.cycleMode(pPlayer.getItemInHand(pUsedHand), pPlayer);
        return InteractionResult.SUCCESS;
    }

    private static void message(ServerPlayer pPlayer, Component pMessageComponent) {
        pPlayer.sendSystemMessage(pMessageComponent, true);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        Mode mode = ClayBrushItem.getMode(pStack);
        if (mode != null) {
            MutableComponent name = mode.getMutableDisplayName();
            PoiPos poiPos = (PoiPos)pStack.get(ModDataComponents.CLAY_BRUSH_POI.get());
            if (mode == Mode.POI && poiPos != null && !poiPos.isEmpty()) {
                name.append((Component)Component.literal((String)(" (" + poiPos.pos.toShortString() + ")")));
            }
            pTooltipComponents.add((Component)name);
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)NO_MODE_LANG).withStyle(ChatFormatting.RED));
        }
    }

    @Nullable
    public static Mode getMode(ItemStack stack) {
        return (Mode)stack.get(ModDataComponents.CLAY_BRUSH_MODE.get());
    }

    public static BlockPos getPoiPos(ItemStack stack) {
        PoiPos poiPos = (PoiPos)stack.get(ModDataComponents.CLAY_BRUSH_POI.get());
        return poiPos == null || poiPos.isEmpty() ? null : poiPos.pos;
    }

    public static enum Mode implements StringRepresentable,
    KeyableTranslatableProperty
    {
        COMMAND(0, "command", 0.0f, 12671542),
        WORK(1, "work", 0.5f, 10101539),
        POI(2, "poi", 1.0f, 1719219);

        public static final IntFunction<Mode> BY_ID;
        public static final StreamCodec<ByteBuf, Mode> STREAM_CODEC;
        public static final Codec<Mode> CODEC;
        private static final String LANG_KEY = "item.%s.clay_rush.mode.%s";
        private final int id;
        private final String serializedName;
        private final float overrideProperty;
        private final int color;

        private Mode(int id, String serializedName, float overrideProperty, int color) {
            this.id = id;
            this.serializedName = serializedName;
            this.overrideProperty = overrideProperty;
            this.color = color;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        public float getOverrideProperty() {
            return this.overrideProperty;
        }

        @Override
        public String translatableKey() {
            return LANG_KEY.formatted("csr", this.serializedName);
        }

        @Override
        public Style getStyle() {
            return Style.EMPTY.withColor(this.color);
        }

        private MutableComponent getMutableDisplayName() {
            return Component.translatable((String)this.translatableKey()).withStyle(this.getStyle());
        }

        static {
            BY_ID = ByIdMap.continuous(mode -> mode.id, (Object[])Mode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, mode -> mode.id);
            CODEC = StringRepresentable.fromEnum(Mode::values);
        }
    }

    public record PoiPos(BlockPos pos, boolean isEmpty) {
        public static final PoiPos EMPTY = new PoiPos(BlockPos.ZERO, true);
        public static final Codec<PoiPos> CODEC = RecordCodecBuilder.create(in -> in.group((App)BlockPos.CODEC.optionalFieldOf("pos", (Object)BlockPos.ZERO).forGetter(PoiPos::pos), (App)Codec.BOOL.optionalFieldOf("empty", (Object)true).forGetter(PoiPos::isEmpty)).apply((Applicative)in, PoiPos::new));
        public static final StreamCodec<ByteBuf, PoiPos> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PoiPos::pos, (StreamCodec)ByteBufCodecs.BOOL, PoiPos::isEmpty, PoiPos::new);
    }
}

