/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelSoldierData;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.boss.ClaySoldierBossEquipment;
import net.bumblebee.claysoldiers.entity.goal.workgoal.dig.DigBreakManger;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.team.TeamLoyaltyManger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestItem
extends Item {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Clay Soldiers Remake Debug");

    public TestItem(Item.Properties pProperties) {
        super(pProperties.component(ModDataComponents.DEBUG_ITEM_MODE.get(), (Object)Mode.TEAM));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        Level level = context.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            TestItem.log(serverLevel.getBlockState(context.getClickedPos()), List.of("PoiType: " + String.valueOf(serverLevel.getPoiManager().getType(context.getClickedPos())), "Occupants: " + (serverLevel.getPoiManager().getType(context.getClickedPos()).map(h -> ((PoiType)h.value()).maxTickets()).orElse(0) - serverLevel.getPoiManager().getFreeTickets(context.getClickedPos()))));
        }
        if (blockEntity instanceof HamsterWheelBlockEntity) {
            HamsterWheelBlockEntity hamsterWheel;
            HamsterWheelSoldierData data = (hamsterWheel = (HamsterWheelBlockEntity)blockEntity).getSoldierData();
            TestItem.log(hamsterWheel, List.of(data == null ? "HamsterWheelSoldierData(null)" : data.toString()));
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult use(Level level, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemInHand = pPlayer.getItemInHand(pUsedHand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getPoiManager().getInSquare(h -> h.is(ModTags.PoiTypes.SOLDIER_CONTAINER), pPlayer.getOnPos(), 10, PoiManager.Occupancy.ANY);
        }
        if (pPlayer.isCrouching()) {
            ItemStack offHand = pPlayer.getItemInHand(InteractionHand.OFF_HAND);
            if (pUsedHand == InteractionHand.MAIN_HAND && !offHand.isEmpty()) {
                LOGGER.info("{}---: {}", (Object)(level.isClientSide ? "Client" : "Server"), (Object)offHand.getItem());
                LOGGER.info("Holdable: {}", (Object)ClaySoldiersCommon.DATA_MAP.getEffect(offHand));
                LOGGER.info("Wearable: {}", (Object)ClaySoldiersCommon.DATA_MAP.getArmor(offHand));
                LOGGER.info("Item Poi: {}", (Object)ClaySoldiersCommon.DATA_MAP.getItemPoi(offHand));
                LOGGER.info("Block Poi: {}", (Object)ClaySoldiersCommon.DATA_MAP.getBlockPoi(offHand));
                LOGGER.info("---");
            } else {
                TestItem.cycleMode(itemInHand, pPlayer);
            }
        } else {
            Mode mode = (Mode)((Object)pPlayer.getItemInHand(pUsedHand).get(ModDataComponents.DEBUG_ITEM_MODE.get()));
            if (mode == null) {
                mode = Mode.TEAM;
            }
            ArrayList<String> info = new ArrayList<String>();
            info.add(level.isClientSide() ? "Client---" : "Server---");
            mode.getInfo(level, pPlayer, info);
            info.add("---");
            info.forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        }
        return InteractionResult.SUCCESS;
    }

    private static void cycleMode(ItemStack itemInHand, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Mode mode = (Mode)((Object)itemInHand.get(ModDataComponents.DEBUG_ITEM_MODE.get()));
            int n = 0;
            Mode newMode = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TEAM", "WORLD", "CONFIG", "BLUEPRINT", "TAGS", "BOSS"}, (Mode)mode, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> Mode.WORLD;
                case 1 -> Mode.CONFIG;
                case 2 -> Mode.BLUEPRINT;
                case 3 -> Mode.TAGS;
                case 4 -> Mode.BOSS;
                case 5 -> Mode.TEAM;
                case -1 -> Mode.TEAM;
            };
            itemInHand.set(ModDataComponents.DEBUG_ITEM_MODE.get(), (Object)newMode);
            serverPlayer.sendSystemMessage(newMode.getDisplayName());
        }
    }

    public static boolean isBlueprintEnabled(Level level) {
        return ClaySoldiersCommon.COMMON_HOOKS.isBlueprintEnabled(level.enabledFeatures());
    }

    public static long wheelSpeed() {
        return ClaySoldiersCommon.COMMON_HOOKS.getHamsterWheelSpeed();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"Right-Click Logs Useful Information to the console").withStyle(ChatFormatting.GOLD));
        tooltipComponents.add((Component)Component.literal((String)"Sneak-Right-Click to change modes").withStyle(ChatFormatting.GOLD));
        Mode mode = (Mode)((Object)stack.get(ModDataComponents.DEBUG_ITEM_MODE.get()));
        if (mode != null) {
            tooltipComponents.add((Component)Component.literal((String)"Mode: ").withStyle(ChatFormatting.DARK_GRAY).append(mode.getDisplayName()));
        } else {
            tooltipComponents.add((Component)Component.literal((String)"Mode: Unselected").withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public static <T> void log(T entity, List<String> infos) {
        LOGGER.info("{}---", entity);
        infos.forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        LOGGER.info("---");
    }

    public static enum Mode implements StringRepresentable
    {
        TEAM("team", ChatFormatting.DARK_GREEN, (level, player, list) -> {
            list.add("Custom Reg and Level: " + String.valueOf(level.registryAccess().lookup(ModRegistries.CLAY_MOB_TEAMS)));
            list.add("Teams: " + String.valueOf(ClayMobTeamManger.getAllKeys((HolderLookup.Provider)level.registryAccess()).toList()));
            list.add("From Item: " + String.valueOf(ClayMobTeamManger.getFromItemMap()));
        }, (s, p, info) -> info.add("Loyalty: " + String.valueOf(TeamLoyaltyManger.getTeamPlayerData(s))), (c, p, info) -> info.add("Loyalty: " + String.valueOf(TeamLoyaltyManger.getClientTeamPlayerData()))),
        WORLD("world", ChatFormatting.BLUE, InfoGenerator.EMPTY, (level, player, list) -> {
            list.add("BreakData: " + String.valueOf(DigBreakManger.get()));
            list.add("DataPack");
            PackRepository packRepository = level.getServer().getPackRepository();
            list.add("Selected: " + String.valueOf(packRepository.getSelectedIds().stream().filter(id -> id.contains("csr") || id.contains("blueprint")).toList()));
            list.add("Available: " + String.valueOf(packRepository.getSelectedIds().stream().filter(id -> id.contains("csr") || id.contains("blueprint")).toList()));
            packRepository.getAvailablePacks().stream().filter(p -> p.getId().contains("csr") || p.getId().contains("blueprint")).forEach(pack -> list.add("Pack(%s [%s], source:%s)".formatted(pack.getDescription().getString(), pack.getId(), pack.getPackSource().decorate((Component)Component.literal((String)"csr")).getString())));
        }, InfoGenerator.EMPTY),
        CONFIG("config", ChatFormatting.YELLOW, (l, p, infos) -> {
            infos.add("Config: MenuModify: %s | WheelSpeed: %s | Blueprint: %s".formatted(ClaySoldiersCommon.claySolderMenuModify ? "Allowed" : "Disabled", TestItem.wheelSpeed(), TestItem.isBlueprintEnabled(l) ? "Enabled" : "Disabled"));
            infos.add("Caps: " + ClaySoldiersCommon.CAPABILITY_MANGER.toString());
        }),
        BLUEPRINT("blueprint", ChatFormatting.AQUA, (l, p, info) -> {
            Registry reg = l.registryAccess().lookupOrThrow(ModRegistries.BLUEPRINTS);
            info.add("Registry(%s): %s".formatted(reg.size(), reg.keySet()));
            info.add("Content: " + String.valueOf(reg.listElements().map(Holder::value).toList()));
        }),
        TAGS("soldier_item_tags", ChatFormatting.DARK_PURPLE, (l, p, info) -> {
            Optional reg = l.registryAccess().lookup(ModRegistries.SOLDIER_ITEM_TYPES);
            info.add("Type Reg: " + String.valueOf(reg));
            info.add("Values: " + String.valueOf(reg.map(r -> r.stream().toList())));
            info.add("Entries: " + String.valueOf(reg.map(Registry::entrySet)));
            info.add("Generators: " + String.valueOf(ModRegistries.ITEM_GENERATORS_REGISTRY.stream().toList()));
            info.add("Entries: " + String.valueOf(ModRegistries.ITEM_GENERATORS_REGISTRY.entrySet()));
        }),
        BOSS("boss", ChatFormatting.RED, InfoGenerator.EMPTY, (serverLevel, p, info) -> {
            BossClaySoldierEntity boss = (BossClaySoldierEntity)ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get().create(serverLevel, EntitySpawnReason.COMMAND);
            if (boss == null) {
                info.add("Error creating Boss");
                return;
            }
            boss.moveTo(p.position());
            ClaySoldierBossEquipment.RANDOM.setUp(boss, 8, null, false);
            if (serverLevel.addFreshEntity((Entity)boss)) {
                info.add("Successfully spawned Boss");
            } else {
                info.add("Error spawning Boss");
            }
        }, InfoGenerator.EMPTY);

        public static final Codec<Mode> CODEC;
        public static final StreamCodec<ByteBuf, Mode> STREAM_CODEC;
        private final String serializedName;
        private final String capitalizedName;
        private final ChatFormatting chatFormatting;
        private final InfoGenerator<Level> toInfo;
        private final InfoGenerator<ServerLevel> server;
        private final InfoGenerator<Level> client;

        private Mode(String serializedName, ChatFormatting chatFormatting, InfoGenerator<Level> toInfo) {
            this(serializedName, chatFormatting, toInfo, InfoGenerator.EMPTY_SERVER, InfoGenerator.EMPTY);
        }

        private Mode(String serializedName, ChatFormatting chatFormatting, InfoGenerator<Level> toInfo, InfoGenerator<ServerLevel> server, InfoGenerator<Level> client) {
            this.serializedName = serializedName;
            this.chatFormatting = chatFormatting;
            this.toInfo = toInfo;
            this.server = server;
            this.client = client;
            StringBuilder builder = new StringBuilder();
            for (String i : serializedName.replace('_', ' ').split(" ")) {
                builder.append(i.replaceFirst("" + i.charAt(0), ("" + i.charAt(0)).toUpperCase()));
            }
            this.capitalizedName = builder.toString();
        }

        public void getInfo(Level level, Player player, List<String> info) {
            this.toInfo.appendInfo(level, player, info);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.server.appendInfo(serverLevel, player, info);
            } else {
                this.client.appendInfo(level, player, info);
            }
        }

        public Component getDisplayName() {
            return Component.literal((String)this.capitalizedName).withStyle(this.chatFormatting);
        }

        @NotNull
        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
            STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
        }
    }

    static interface InfoGenerator<L extends Level> {
        public static final InfoGenerator<Level> EMPTY = (l, p, infoList) -> {};
        public static final InfoGenerator<ServerLevel> EMPTY_SERVER = (l, p, infoList) -> {};

        public void appendInfo(L var1, Player var2, List<String> var3);
    }
}

