/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.blueprint;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.bumblebee.claysoldiers.blueprint.BlueprintData;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.item.blueprint.BlueprintPageItem;
import net.bumblebee.claysoldiers.item.blueprint.tooltip.BlueprintTooltip;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;

public class BlueprintItem
extends BlueprintPageItem {
    public static final String DESCRIPTION_ID = "item.csr.blueprint";
    public static final String DESCRIPTION_ID_WITH_STRUCTURE = "item.csr.blueprint_with_structure";
    public static final String STRUCTURE_NAME_LANG = "item.csr.blueprint.structure_name";
    public static final String BLUEPRINT_INVALID_LANG = "item.csr.blueprint.invalid";

    public BlueprintItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        if (!pTooltipFlag.isAdvanced()) {
            return;
        }
        ResourceLocation dataLoc = (ResourceLocation)pStack.get(ModDataComponents.BLUEPRINT_DATA.get());
        if (dataLoc != null) {
            pTooltipComponents.add((Component)Component.translatable((String)STRUCTURE_NAME_LANG, (Object[])new Object[]{dataLoc.toString()}).withStyle(ChatFormatting.DARK_GRAY));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)BLUEPRINT_INVALID_LANG).withStyle(ChatFormatting.RED));
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack pStack) {
        return !pStack.has(DataComponents.HIDE_TOOLTIP) && !pStack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((ResourceLocation)pStack.get(ModDataComponents.BLUEPRINT_DATA.get())).map(BlueprintTooltip::new) : Optional.empty();
    }

    public static ItemStack createStackFromData(Holder<BlueprintData> holder) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.BLUEPRINT.get());
        stack.set(ModDataComponents.BLUEPRINT_DATA.get(), (Object)((ResourceKey)holder.unwrapKey().orElseThrow(() -> new IllegalStateException("Cannot create ItemStack for non-register Date: " + String.valueOf(holder)))).location());
        stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)DESCRIPTION_ID_WITH_STRUCTURE, (Object[])new Object[]{((BlueprintData)holder.value()).getDisplayName()}));
        stack.set(ModDataComponents.BLUEPRINT_ITEM_DATA.get(), (Object)new BlueprintItemData(((BlueprintData)holder.value()).marking()));
        return stack;
    }

    public record BlueprintItemData(float marking) {
        public static final Codec<BlueprintItemData> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.FLOAT.fieldOf("marking").forGetter(BlueprintItemData::marking)).apply((Applicative)in, BlueprintItemData::new));
        public static final StreamCodec<ByteBuf, BlueprintItemData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, BlueprintItemData::marking, BlueprintItemData::new);
    }
}

