/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.blueprint.tooltip;

import java.util.List;
import net.bumblebee.claysoldiers.blueprint.BlueprintData;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ClientBlueprintTooltip
implements ClientTooltipComponent {
    private static final int MAX_ITEMS_PER_ROW = 10;
    private static final int ITEM_SIZE = 18;
    private static final int ITEM_PADDING = 1;
    private final List<ItemStack> contents;

    public ClientBlueprintTooltip(ResourceLocation dataKey) {
        List<Object> contentCopy;
        BlueprintData data = (BlueprintData)Minecraft.getInstance().player.registryAccess().lookupOrThrow(ModRegistries.BLUEPRINTS).getValue(dataKey);
        if (data == null) {
            contentCopy = List.of();
        } else {
            try {
                contentCopy = data.getTemplate().getNeededItems();
            }
            catch (IllegalStateException e) {
                contentCopy = List.of();
            }
        }
        this.contents = contentCopy;
    }

    public int getHeight(Font font) {
        return 4 + 18 * ClientBlueprintTooltip.divideCeil(this.contents.size());
    }

    public int getWidth(Font font) {
        return 18 * Math.min(this.contents.size(), 10);
    }

    public void renderImage(Font font, int pX, int pY, int width, int height, GuiGraphics guiGraphics) {
        for (int itemIndex = 0; itemIndex < this.contents.size(); ++itemIndex) {
            int elementX = 1 + pX + itemIndex % 10 * 18;
            int elementY = 1 + pY + itemIndex / 10 * 18;
            this.renderItem(elementX, elementY, itemIndex, guiGraphics, font);
        }
    }

    private void renderItem(int pX, int pY, int pItemIndex, GuiGraphics pGuiGraphics, Font pFont) {
        ItemStack itemstack = this.contents.get(pItemIndex);
        pGuiGraphics.renderItem(itemstack, pX + 1, pY + 1, pItemIndex);
        pGuiGraphics.renderItemDecorations(pFont, itemstack, pX + 1, pY + 1);
    }

    private static int divideCeil(int numerator) {
        return (int)Math.ceil((float)numerator / 10.0f);
    }
}

