/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.claymobspawn;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ClaySoldierOnHeadModel<T extends PlayerRenderState>
extends HumanoidModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"csr", (String)"clay_soldier_on_head"), "main");
    private static final String SOLDIER_NAME = "soldier";
    private static final String SOLDIER_LEFT_ARM = "soldier_left_arm";
    private static final String SOLDIER_RIGHT_ARM = "soldier_right_arm";
    private static final ResourceLocation SOLDIER_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/block/clay.png");
    public static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)SOLDIER_TEXTURE);
    public final ModelPart soldierHead;
    public final ModelPart soldierLeftArm;
    public final ModelPart soldierRightArm;

    public ClaySoldierOnHeadModel(ModelPart root) {
        super(root);
        ModelPart soldier = root.getChild("head").getChild(SOLDIER_NAME);
        this.soldierHead = soldier.getChild("soldier_head");
        this.soldierLeftArm = soldier.getChild(SOLDIER_LEFT_ARM);
        this.soldierRightArm = soldier.getChild(SOLDIER_RIGHT_ARM);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, int color) {
        this.renderToBuffer(poseStack, buffer.getBuffer(RENDER_TYPE), packedLight, OverlayTexture.NO_OVERLAY, color);
    }

    public void setupAnimSoldierAnim(LivingEntityRenderState p_361833_) {
        float f1 = p_361833_.walkAnimationPos;
        float f2 = p_361833_.walkAnimationSpeed;
        this.rightArm.xRot = Mth.cos((float)(f1 * 0.6662f + (float)Math.PI)) * 2.0f * f2 * 0.5f;
        this.leftArm.xRot = Mth.cos((float)(f1 * 0.6662f)) * 2.0f * f2 * 0.5f;
    }

    public void copyHeadRotation(HumanoidModel<?> toCopyFrom) {
        this.head.xRot = toCopyFrom.head.xRot;
        this.head.yRot = toCopyFrom.head.yRot;
        this.head.zRot = toCopyFrom.head.zRot;
    }

    public static ClaySoldierOnHeadModel<?> createModel() {
        return ClaySoldierOnHeadModel.createModel(arg_0 -> ((EntityModelSet)Minecraft.getInstance().getEntityModels()).bakeLayer(arg_0));
    }

    public static ClaySoldierOnHeadModel<?> createModel(Function<ModelLayerLocation, ModelPart> bakery) {
        return new ClaySoldierOnHeadModel(bakery.apply(LAYER_LOCATION));
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition root = meshDefinition.getRoot();
        PartDefinition headPart = root.clearChild("head");
        headPart.clearChild("hat");
        PartDefinition soldier = headPart.addOrReplaceChild(SOLDIER_NAME, CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -16.0f, -1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)1.0f));
        soldier.addOrReplaceChild("leg_right", CubeListBuilder.create().texOffs(0, 8).addBox(0.0f, -1.0f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        soldier.addOrReplaceChild("leg_left", CubeListBuilder.create().texOffs(0, 4).addBox(-1.0f, -1.0f, -3.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f));
        soldier.addOrReplaceChild("soldier_head", CubeListBuilder.create().texOffs(8, 0).addBox(-1.0f, -5.0f, -1.5f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        soldier.addOrReplaceChild(SOLDIER_LEFT_ARM, CubeListBuilder.create().texOffs(8, 4).addBox(-2.0f, -3.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        soldier.addOrReplaceChild(SOLDIER_RIGHT_ARM, CubeListBuilder.create().texOffs(8, 4).addBox(1.0f, -3.0f, -1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f));
        root.clearChild("body");
        root.clearChild("left_arm");
        root.clearChild("right_arm");
        root.clearChild("left_leg");
        root.clearChild("right_leg");
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)16, (int)16);
    }
}

