/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.claypouch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.bumblebee.claysoldiers.blueprint.templates.BlueprintUtil;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.item.claymobspawn.MultiSpawnItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ClayPouchContent
implements TooltipComponent {
    public static final int ABSOLUTE_MAX_CAPACITY = 1024;
    private static final Codec<MultiSpawnItem<?>> MULTI_SPAWN_ITEM_CODEC = BuiltInRegistries.ITEM.byNameCodec().comapFlatMap(item -> {
        if (item instanceof MultiSpawnItem) {
            MultiSpawnItem multiSpawnItem = (MultiSpawnItem)((Object)item);
            return DataResult.success((Object)((Object)multiSpawnItem));
        }
        return DataResult.error(() -> String.valueOf(item) + " is not a " + MultiSpawnItem.class.getSimpleName());
    }, Function.identity());
    public static final Codec<ClayPouchContent> CODEC = RecordCodecBuilder.create(in -> in.group((App)MULTI_SPAWN_ITEM_CODEC.fieldOf("doll").forGetter(s -> s.item), (App)Codec.intRange((int)0, (int)1024).fieldOf("count").forGetter(s -> s.count), (App)Codec.intRange((int)0, (int)1024).fieldOf("max_capacity").forGetter(s -> s.maxCapacity), (App)DataComponentMap.CODEC.optionalFieldOf("data", (Object)DataComponentMap.EMPTY).forGetter(s -> s.data)).apply((Applicative)in, ClayPouchContent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClayPouchContent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), s -> s.item, (StreamCodec)ByteBufCodecs.VAR_INT, s -> s.count, (StreamCodec)ByteBufCodecs.VAR_INT, s -> s.maxCapacity, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec((Codec)DataComponentMap.CODEC)), ClayPouchContent::dataComponents, (item, count, maxCap, opt) -> ClayPouchContent.createUnsafe(item, count, maxCap, opt.orElse(DataComponentMap.EMPTY)));
    private final MultiSpawnItem<?> item;
    private final int count;
    private final DataComponentMap data;
    private final int maxCapacity;

    public ClayPouchContent(MultiSpawnItem<?> item, int count, int maxCapacity, DataComponentMap map) {
        this.item = item;
        this.count = count;
        this.data = map;
        this.maxCapacity = Math.min(1024, maxCapacity);
    }

    private static ClayPouchContent createUnsafe(Item item, int count, int maxCapacity, DataComponentMap map) {
        try {
            return new ClayPouchContent((MultiSpawnItem)item, count, maxCapacity, map);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("%s does not extend %s".formatted(item, MultiSpawnItem.class.getSimpleName()));
        }
    }

    public int getColor(LivingEntity player) {
        return this.item.getPouchColor(this.data, player);
    }

    public int maxRemaining(int newMaxCapacity) {
        return newMaxCapacity - this.count;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public int getFillPercent(int maxCapacity) {
        return (int)Math.clamp((float)this.count * 13.0f / (float)maxCapacity, 1.0f, 13.0f);
    }

    public int getCount() {
        return this.count;
    }

    public ClayPouchContent increment(int grow, int maxCapacity) {
        return new ClayPouchContent(this.item, this.count + grow, maxCapacity, this.data);
    }

    @Nullable
    public ClayPouchContent shrink(int amount, int maxCapacity) {
        if (amount >= this.count) {
            return null;
        }
        return this.increment(-amount, maxCapacity);
    }

    public boolean isFor(ItemStack stack) {
        if (stack.getItem() != this.item) {
            return false;
        }
        return this.data.stream().allMatch(type -> type.value().equals(stack.get(type.type())));
    }

    public MultiSpawnItem<?> getItem() {
        return this.item;
    }

    @Nullable
    public ClayPouchContent takeStack(Consumer<ItemStack> taken, int maxCapacity, HolderLookup.Provider registries) {
        int used = Math.min(this.count, this.item.getDefaultMaxStackSize());
        ItemStack stack = this.createStack(registries);
        stack.setCount(used);
        this.dataComponents().ifPresent(arg_0 -> ((ItemStack)stack).applyComponents(arg_0));
        taken.accept(stack);
        return this.shrink(used, maxCapacity);
    }

    public ItemStack createStack(HolderLookup.Provider registries) {
        return this.item.recreateStackFromPouch(this.data, registries);
    }

    public void insert(ItemStack stack, int maxCapacity, BiConsumer<ClayPouchContent, Integer> onSuccess) {
        if (this.isFor(stack)) {
            int inserted = Math.min(stack.getCount(), this.maxRemaining(maxCapacity));
            onSuccess.accept(this.increment(inserted, maxCapacity), inserted);
        }
    }

    public Iterable<ItemStack> copyItems() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        BlueprintUtil.addItemStackToList(stacks, this.item, this.count);
        return stacks;
    }

    public Optional<DataComponentMap> dataComponents() {
        return this.data == DataComponentMap.EMPTY ? Optional.empty() : Optional.of(this.data);
    }

    public static boolean onPouch(ItemStack stack, UnaryOperator<ClayPouchContent> operation) {
        ClayPouchContent content = (ClayPouchContent)stack.get(ModDataComponents.CLAY_POUCH_CONTENT.get());
        if (content != null) {
            stack.set(ModDataComponents.CLAY_POUCH_CONTENT.get(), (Object)((ClayPouchContent)operation.apply(content)));
            return true;
        }
        return false;
    }

    public static int verifyMaxCapacity(int maxCapacity) {
        return Math.min(maxCapacity, 1024);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClayPouchContent content = (ClayPouchContent)o;
        return this.count == content.count && Objects.equals(this.item, content.item) && Objects.equals(this.data, content.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.item, this.count, this.data});
    }

    public String toString() {
        return "PouchContent(%s: %d)".formatted(new Object[]{this.item, this.count});
    }
}

