/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.claypouch;

import net.bumblebee.claysoldiers.item.claypouch.ClayPouchContent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;

public class ClientClayPouchTooltip
implements ClientTooltipComponent {
    private static final int ITEM_PADDING = 1;
    private static final int ITEM_SIZE = 18;
    private final int count;
    private final ItemStack stack;

    public ClientClayPouchTooltip(ClayPouchContent content) {
        this.count = content.getCount();
        this.stack = content.createStack((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
    }

    public int getHeight(Font font) {
        return 22;
    }

    public int getWidth(Font font) {
        return 18;
    }

    public void renderImage(Font font, int x, int y, int width, int height, GuiGraphics guiGraphics) {
        this.renderItem(1 + x, 1 + y, this.stack, "" + this.count, guiGraphics, font);
    }

    private void renderItem(int pX, int pY, ItemStack stack, String count, GuiGraphics pGuiGraphics, Font pFont) {
        pGuiGraphics.renderItem(stack, pX + 1, pY + 1);
        pGuiGraphics.renderItemDecorations(pFont, stack, pX + 1, pY + 1, count);
    }
}

