/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.disruptor;

import java.util.List;
import net.bumblebee.claysoldiers.block.ClayMobContainer;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.init.ModCriterions;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.item.disruptor.DisruptorKillRange;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ClayMobKillItem
extends Item {
    public static final String RANGE_LANG = "item.csr.disruptor.range";
    public static final String RANGE_UNLIMITED_LANG = "item.csr.disruptor.range.unlimited";
    public static final String RANGE_ERROR_LANG = "item.csr.disruptor.range.error";

    public ClayMobKillItem(Item.Properties pProperties, DisruptorKillRange range) {
        super(pProperties.component(ModDataComponents.DISRUPTOR_KILL_RANGE.get(), (Object)range));
    }

    public InteractionResult use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                if (pUsedHand == InteractionHand.MAIN_HAND) {
                    int amountKilled = this.killSoldiers(pPlayer.getItemInHand(pUsedHand), serverLevel, pPlayer.getOnPos(), serverPlayer);
                    ModCriterions.DISRUPTOR_KILL_TRIGGER.get().trigger(serverPlayer, amountKilled);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        DisruptorKillRange range = (DisruptorKillRange)stack.get(ModDataComponents.DISRUPTOR_KILL_RANGE.get());
        if (range == null) {
            tooltipComponents.add((Component)Component.translatable((String)RANGE_ERROR_LANG).withStyle(ChatFormatting.RED));
        } else if (tooltipFlag.isAdvanced()) {
            tooltipComponents.add((Component)CommonComponents.space().append(range.appendRangeToComponent(RANGE_LANG, RANGE_UNLIMITED_LANG)).withStyle(ChatFormatting.GRAY));
        }
    }

    private int killSoldiers(ItemStack stack, ServerLevel level, BlockPos center, ServerPlayer player) {
        DisruptorKillRange killRange = (DisruptorKillRange)stack.get(ModDataComponents.DISRUPTOR_KILL_RANGE.get());
        if (killRange == null) {
            return -1;
        }
        List<? extends ClayMobEntity> clayMobEntities = killRange.getEntitiesInRange(level, player, center);
        for (ClayMobEntity clayMobEntity : clayMobEntities) {
            clayMobEntity.kill(level);
        }
        List<ClayMobContainer> soldierContainer = killRange.getClaySoldierContainers(level, player, center);
        soldierContainer.forEach(blockEntity -> blockEntity.killSoldier(level, player));
        return clayMobEntities.size() + soldierContainer.size();
    }

    public ItemUseAnimation getUseAnimation(ItemStack pStack) {
        return ItemUseAnimation.BRUSH;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity p_344979_) {
        return 10;
    }
}

