/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.disruptor;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.ClayMobContainer;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.init.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class DisruptorKillRange {
    private static final int MAX_RANGE = 64;
    public static final Codec<DisruptorKillRange> CODEC = Codec.either((Codec)Codec.floatRange((float)1.0f, (float)64.0f), (Codec)Codec.STRING).comapFlatMap(DisruptorKillRange::getFromEither, DisruptorKillRange::createEither);
    public static final StreamCodec<ByteBuf, DisruptorKillRange> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, d -> Float.valueOf(d.range), (StreamCodec)ByteBufCodecs.BOOL, d -> d.unlimited, DisruptorKillRange::new);
    private static final String UNLIMITED_RANGE = "unlimited";
    private final float range;
    private final boolean unlimited;

    private DisruptorKillRange(float range, boolean unlimited) {
        this.range = range;
        this.unlimited = unlimited;
    }

    public static DisruptorKillRange unlimited() {
        return new DisruptorKillRange(0.0f, true);
    }

    public static DisruptorKillRange range(float range) {
        return new DisruptorKillRange(range, false);
    }

    public Component appendRangeToComponent(String rangedKey, String unlimitedKey) {
        return this.unlimited ? Component.translatable((String)rangedKey, (Object[])new Object[]{Component.translatable((String)unlimitedKey)}) : Component.translatable((String)rangedKey, (Object[])new Object[]{Float.valueOf(this.range)});
    }

    public List<? extends ClayMobEntity> getEntitiesInRange(ServerLevel level, ServerPlayer serverPlayer, BlockPos center) {
        List clayMobs = this.unlimited ? level.getEntities(EntityTypeTest.forClass(ClayMobEntity.class), c -> c.canBeKilledByDisruptor(level, serverPlayer)) : (this.range >= 1.0f ? level.getEntitiesOfClass(ClayMobEntity.class, new AABB(center).inflate((double)this.range), c -> c.canBeKilledByDisruptor(level, serverPlayer)) : List.of());
        return clayMobs;
    }

    public List<ClayMobContainer> getClaySoldierContainers(ServerLevel level, ServerPlayer player, BlockPos center) {
        int range = this.unlimited ? 64 : Math.max(64, (int)this.range);
        return level.getPoiManager().getInSquare(h -> h.is(ModTags.PoiTypes.SOLDIER_CONTAINER), center, range, PoiManager.Occupancy.IS_OCCUPIED).map(p -> DisruptorKillRange.getClayMobContainer(level, p.getPos())).filter(c -> c != null && c.canKillClayMob(level, player)).toList();
    }

    @Nullable
    private static ClayMobContainer getClayMobContainer(ServerLevel level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ClayMobContainer) {
            ClayMobContainer clayMobContainer = (ClayMobContainer)blockEntity;
            return clayMobContainer;
        }
        ClaySoldiersCommon.LOGGER.error("ClayMobContainerPoi({}) does not implement {}", (Object)pos.toShortString(), (Object)HamsterWheelBlockEntity.class.getSimpleName());
        return null;
    }

    private static DataResult<DisruptorKillRange> getFromEither(Either<Float, String> either) {
        if (either.left().isPresent()) {
            return DataResult.success((Object)DisruptorKillRange.range(((Float)either.left().orElseThrow()).floatValue()));
        }
        String range = either.right().orElse("");
        if (range.equals(UNLIMITED_RANGE)) {
            return DataResult.success((Object)DisruptorKillRange.unlimited());
        }
        return DataResult.error(() -> "Cannot parse range %s".formatted(range), (Object)new DisruptorKillRange(0.0f, false));
    }

    private Either<Float, String> createEither() {
        if (this.unlimited) {
            return Either.right((Object)UNLIMITED_RANGE);
        }
        return Either.left((Object)Float.valueOf(this.range));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisruptorKillRange that = (DisruptorKillRange)o;
        return Float.compare(this.range, that.range) == 0 && this.unlimited == that.unlimited;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.range), this.unlimited);
    }
}

