/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.itemeffectholder;

import java.util.function.Function;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.capability.ThrowableItemCapability;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.armor.SoldierMultiWearable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.SoldierAccessorySlot;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackEffectHolder;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.RangedAttackType;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackWithEffect
extends ItemStackEffectHolder<SoldierHoldableEffect> {
    public static final ItemStackWithEffect EMPTY = new ItemStackWithEffect(ItemStack.EMPTY, null, null);
    @NotNull
    private final SoldierMultiWearable wearableEffect;

    public ItemStackWithEffect(ItemStack stack, @Nullable SoldierHoldableEffect effect, @Nullable SoldierMultiWearable wearableEffect) {
        super(stack, effect);
        this.wearableEffect = wearableEffect == null ? SoldierMultiWearable.empty() : wearableEffect;
    }

    public ItemStackWithEffect(ItemStack stack) {
        this(stack, ClaySoldiersCommon.DATA_MAP.getEffect(stack), ClaySoldiersCommon.DATA_MAP.getArmor(stack));
    }

    @Override
    protected SoldierHoldableEffect createEffectOnInitialisation(ItemStack stack) {
        return ClaySoldiersCommon.DATA_MAP.getEffect(stack);
    }

    public static ItemStackWithEffect parseOptional(HolderLookup.Provider provider, CompoundTag pCompoundTag) {
        return new ItemStackWithEffect(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)pCompoundTag));
    }

    public boolean isThrowable() {
        return this.effect != null && ((SoldierHoldableEffect)this.effect).throwable();
    }

    public boolean throwableTypeMatchAttackType(AttackTypeProperty attackType) {
        if (this.effect == null || !((SoldierHoldableEffect)this.effect).throwable()) {
            return true;
        }
        if (attackType.isSupportive()) {
            return ((SoldierHoldableEffect)this.effect).throwableType(RangedAttackType.HELPING);
        }
        if (attackType.fightsBack()) {
            return ((SoldierHoldableEffect)this.effect).throwableType(RangedAttackType.HARM);
        }
        return true;
    }

    public boolean isShield() {
        return this.wearableEffect.getAccessories().get(SoldierAccessorySlot.SHIELD) != null;
    }

    public boolean isGlider() {
        return this.effect != null && ((SoldierHoldableEffect)this.effect).properties().canGlide() && this.wearableEffect.getAccessories().get(SoldierAccessorySlot.GLIDER) != null;
    }

    public float dropRate() {
        return this.effect != null ? ((SoldierHoldableEffect)this.effect).dropRate() : 1.0f;
    }

    @NotNull
    public ThrowableItemCapability getThrowableCap() {
        Function<ItemStackWithEffect, ThrowableItemCapability> factory = ClaySoldiersCommon.CAPABILITY_MANGER.getThrowableItem(this.stack);
        if (factory != null) {
            return factory.apply(this);
        }
        return ThrowableItemCapability.DEFAULT;
    }

    @Override
    @Nullable
    public SoldierHoldableEffect effect() {
        if (this.effect == null) {
            return ClaySoldiersCommon.DATA_MAP.getEffect(this.stack);
        }
        return (SoldierHoldableEffect)this.effect;
    }

    @NotNull
    public SoldierMultiWearable wearableEffectMap() {
        return this.wearableEffect;
    }

    public boolean canBeReplaced(ItemStackWithEffect other) {
        if (this.stack.isEmpty() || this.effect == null) {
            return true;
        }
        if (other.stack.isEmpty() || other.effect == null) {
            return false;
        }
        return ((SoldierHoldableEffect)this.effect).pickUpPriority() < ((SoldierHoldableEffect)other.effect).pickUpPriority();
    }

    public ItemStackWithEffect copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new ItemStackWithEffect(this.stack.copy());
    }

    public int maxSoldierStackSize() {
        if (this.effect != null) {
            return Math.min(((SoldierHoldableEffect)this.effect).getMaxStackSize(), this.stack.getMaxStackSize());
        }
        return 1;
    }

    public String toString() {
        return "ItemStackWithEffect{" + String.valueOf(this.stack) + ", effect=" + String.valueOf(this.effect) + ", wearableEffect=" + String.valueOf(this.wearableEffect) + "}";
    }
}

