/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.menu;

import java.util.Optional;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractClayMobMenu<T extends ClayMobEntity>
extends AbstractContainerMenu {
    protected int inventoryYOffset;

    protected AbstractClayMobMenu(@Nullable MenuType<?> pMenuType, int pContainerId, Inventory inv) {
        super(pMenuType, pContainerId);
    }

    protected void initPlayerInventory(Inventory inventory) {
        this.addPlayerHotbar(inventory);
        this.addPlayerInventory(inventory);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, this.inventoryYOffset + 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142 + this.inventoryYOffset));
        }
    }

    protected abstract Optional<T> getSource();

    public boolean stillValid(Player pPlayer) {
        if (this.getSource().isEmpty()) {
            return false;
        }
        return ((ClayMobEntity)this.getSource().get()).isAlive() && ((ClayMobEntity)this.getSource().get()).distanceTo((Entity)pPlayer) < 8.0f;
    }

    public void forSourceIfPresent(Consumer<T> action) {
        this.getSource().ifPresent(action);
    }
}

